/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.NettyTransportCodec;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServer.class.getName());
    private final Responder responder;
    private final Channel serverChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup("avro-netty-server");
    private final ChannelFactory channelFactory;
    private final CountDownLatch closed = new CountDownLatch(1);
    private final ExecutionHandler executionHandler;

    public NettyServer(Responder responder, InetSocketAddress addr) {
        this(responder, addr, new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
    }

    public NettyServer(Responder responder, InetSocketAddress addr, ChannelFactory channelFactory) {
        this(responder, addr, channelFactory, null);
    }

    public NettyServer(Responder responder, InetSocketAddress addr, ChannelFactory channelFactory, final ChannelPipelineFactory pipelineFactory, final ExecutionHandler executionHandler) {
        this.responder = responder;
        this.channelFactory = channelFactory;
        this.executionHandler = executionHandler;
        ServerBootstrap bootstrap = new ServerBootstrap(channelFactory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline p = pipelineFactory.getPipeline();
                p.addLast("frameDecoder", new NettyTransportCodec.NettyFrameDecoder());
                p.addLast("frameEncoder", new NettyTransportCodec.NettyFrameEncoder());
                if (executionHandler != null) {
                    p.addLast("executionHandler", executionHandler);
                }
                p.addLast("handler", new NettyServerAvroHandler());
                return p;
            }
        });
        this.serverChannel = bootstrap.bind(addr);
        this.allChannels.add(this.serverChannel);
    }

    public NettyServer(Responder responder, InetSocketAddress addr, ChannelFactory channelFactory, ExecutionHandler executionHandler) {
        this(responder, addr, channelFactory, new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline();
            }
        }, executionHandler);
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
        this.closed.countDown();
    }

    @Override
    public int getPort() {
        return ((InetSocketAddress)this.serverChannel.getLocalAddress()).getPort();
    }

    @Override
    public void join() throws InterruptedException {
        this.closed.await();
    }

    public int getNumActiveConnections() {
        return this.allChannels.size() - 1;
    }

    class NettyServerAvroHandler
    extends SimpleChannelUpstreamHandler {
        private NettyTransceiver connectionMetadata = new NettyTransceiver();

        NettyServerAvroHandler() {
        }

        @Override
        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof ChannelStateEvent) {
                LOG.info(e.toString());
            }
            super.handleUpstream(ctx, e);
        }

        @Override
        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NettyServer.this.allChannels.add(e.getChannel());
            super.channelOpen(ctx, e);
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            try {
                NettyTransportCodec.NettyDataPack dataPack = (NettyTransportCodec.NettyDataPack)e.getMessage();
                List<ByteBuffer> req = dataPack.getDatas();
                List<ByteBuffer> res = NettyServer.this.responder.respond(req, this.connectionMetadata);
                if (res != null) {
                    dataPack.setDatas(res);
                    e.getChannel().write(dataPack);
                }
            }
            catch (IOException ex) {
                LOG.warn("unexpect error");
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            LOG.warn("Unexpected exception from downstream.", e.getCause());
            e.getChannel().close();
            NettyServer.this.allChannels.remove(e.getChannel());
        }

        @Override
        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            LOG.info("Connection to {} disconnected.", e.getChannel().getRemoteAddress());
            super.channelClosed(ctx, e);
            e.getChannel().close();
            NettyServer.this.allChannels.remove(e.getChannel());
        }
    }
}

