/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.source;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ComponentConfigurationFactory;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.conf.FlumeConfigurationError;
import org.apache.flume.conf.FlumeConfigurationErrorType;
import org.apache.flume.conf.channel.ChannelSelectorConfiguration;
import org.apache.flume.conf.channel.ChannelSelectorType;

public class SourceConfiguration
extends ComponentConfiguration {
    protected Set<String> channels = new HashSet<String>();
    protected ChannelSelectorConfiguration selectorConf;

    public SourceConfiguration(String componentName) {
        super(componentName);
    }

    public Set<String> getChannels() {
        return this.channels;
    }

    public ChannelSelectorConfiguration getSelectorConfiguration() {
        return this.selectorConf;
    }

    @Override
    public void configure(Context context) throws ConfigurationException {
        super.configure(context);
        try {
            String channelList = context.getString("channels");
            if (channelList != null) {
                this.channels = new HashSet<String>(Arrays.asList(channelList.split("\\s+")));
            }
            if (this.channels.isEmpty()) {
                this.errors.add(new FlumeConfigurationError(this.componentName, ComponentConfiguration.ComponentType.CHANNEL.getComponentType(), FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
                throw new ConfigurationException("No channels set for " + this.getComponentName());
            }
            ImmutableMap<String, String> selectorParams = context.getSubProperties("selector.");
            String selType = selectorParams != null && !selectorParams.isEmpty() ? (String)selectorParams.get("type") : ChannelSelectorConfiguration.ChannelSelectorConfigurationType.REPLICATING.toString();
            if (selType == null || selType.isEmpty()) {
                selType = ChannelSelectorConfiguration.ChannelSelectorConfigurationType.REPLICATING.toString();
            }
            ChannelSelectorType selectorType = this.getKnownChannelSelector(selType);
            Context selectorContext = new Context();
            selectorContext.putAll((Map<String, String>)selectorParams);
            String config = null;
            if (selectorType == null) {
                config = selectorContext.getString("config");
                if (config == null || config.isEmpty()) {
                    config = "OTHER";
                }
            } else {
                config = selectorType.toString().toUpperCase(Locale.ENGLISH);
            }
            this.selectorConf = (ChannelSelectorConfiguration)ComponentConfigurationFactory.create(ComponentConfiguration.ComponentType.CHANNELSELECTOR.getComponentType(), config, ComponentConfiguration.ComponentType.CHANNELSELECTOR);
            this.selectorConf.setChannels(this.channels);
            this.selectorConf.configure(selectorContext);
        }
        catch (Exception e) {
            this.errors.add(new FlumeConfigurationError(this.componentName, ComponentConfiguration.ComponentType.CHANNELSELECTOR.getComponentType(), FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
            throw new ConfigurationException("Failed to configure component!", e);
        }
    }

    @Override
    public String toString(int indentCount) {
        String basicStr = super.toString(indentCount);
        StringBuilder sb = new StringBuilder();
        sb.append(basicStr).append("CHANNELS:");
        for (String channel : this.channels) {
            sb.append("  ").append(channel).append(FlumeConfiguration.NEWLINE);
        }
        return sb.toString();
    }

    private ChannelSelectorType getKnownChannelSelector(String type) {
        ChannelSelectorType[] values;
        for (ChannelSelectorType value : values = ChannelSelectorType.values()) {
            if (value.toString().equalsIgnoreCase(type)) {
                return value;
            }
            String clName = value.getChannelSelectorClassName();
            if (clName == null || !clName.equalsIgnoreCase(type)) continue;
            return value;
        }
        return null;
    }

    public static enum SourceConfigurationType {
        OTHER(null),
        SEQ(null),
        NETCAT("org.apache.flume.conf.source.NetcatSourceConfiguration"),
        EXEC("org.apache.flume.conf.source.ExecSourceConfiguration"),
        AVRO("org.apache.flume.conf.source.AvroSourceConfiguration"),
        SYSLOGTCP("org.apache.flume.conf.source.SyslogTcpSourceConfiguration"),
        SYSLOGUDP("org.apache.flume.conf.source.SyslogUDPSourceConfiguration"),
        MULTIPORT_SYSLOGTCP("org.apache.flume.source.MultiportSyslogTCPSourceConfiguration"),
        SPOOLDIR("org.apache.flume.conf.source.SpoolDirectorySourceConfiguration"),
        HTTP("org.apache.flume.source.http.HTTPSourceConfiguration"),
        THRIFT("org.apache.flume.source.http.ThriftSourceConfiguration"),
        JMS("org.apache.flume.conf.source.jms.JMSSourceConfiguration"),
        TAILDIR("org.apache.flume.source.taildir.TaildirSourceConfiguration");

        private String srcConfigurationName;

        private SourceConfigurationType(String src) {
            this.srcConfigurationName = src;
        }

        public String getSourceConfigurationType() {
            return this.getSourceConfigurationType();
        }

        public SourceConfiguration getConfiguration(String name) throws ConfigurationException {
            if (this.equals((Object)OTHER)) {
                return new SourceConfiguration(name);
            }
            Class<?> clazz = null;
            SourceConfiguration instance = null;
            try {
                if (this.srcConfigurationName != null) {
                    clazz = Class.forName(this.srcConfigurationName);
                    instance = (SourceConfiguration)clazz.getConstructor(String.class).newInstance(name);
                } else {
                    instance = new SourceConfiguration(name);
                    instance.setNotFoundConfigClass();
                }
            }
            catch (ClassNotFoundException e) {
                instance = new SourceConfiguration(name);
                instance.setNotFoundConfigClass();
            }
            catch (Exception e) {
                throw new ConfigurationException("Error creating configuration", e);
            }
            return instance;
        }
    }
}

