/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.CodedOutputStream;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.ConnectionResetException;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.MultiAction;
import org.hbase.async.NoSuchColumnFamilyException;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PleaseThrottleException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionClientStats;
import org.hbase.async.RegionInfo;
import org.hbase.async.RegionMovedException;
import org.hbase.async.RegionOpeningException;
import org.hbase.async.RemoteException;
import org.hbase.async.SecureRpcHelper;
import org.hbase.async.SecureRpcHelper94;
import org.hbase.async.SecureRpcHelper96;
import org.hbase.async.UnknownRowLockException;
import org.hbase.async.UnknownScannerException;
import org.hbase.async.VersionMismatchException;
import org.hbase.async.generated.ClientPB;
import org.hbase.async.generated.HBasePB;
import org.hbase.async.generated.RPCPB;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegionClient
extends ReplayingDecoder<VoidEnum> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionClient.class);
    private static final HashMap<String, HBaseException> REMOTE_EXCEPTION_TYPES = new HashMap();
    private static final byte SERVER_VERSION_UNKNWON = 0;
    static final byte SERVER_VERSION_090_AND_BEFORE = 24;
    static final byte SERVER_VERSION_092_OR_ABOVE = 29;
    static final byte SERVER_VERSION_095_OR_ABOVE = 95;
    private final HBaseClient hbase_client;
    private final boolean check_write_status;
    private volatile Channel chan;
    private boolean dead = false;
    private byte server_version = 0;
    private MultiAction batched_rpcs;
    private ArrayList<HBaseRpc> pending_rpcs;
    private final ConcurrentHashMap<Integer, HBaseRpc> rpcs_inflight = new ConcurrentHashMap();
    private final AtomicInteger rpcid = new AtomicInteger(-1);
    private final AtomicInteger rpcs_sent = new AtomicInteger();
    private final AtomicInteger rpcs_timedout = new AtomicInteger();
    private final AtomicInteger rpc_response_timedout = new AtomicInteger();
    private final AtomicInteger rpc_response_unknown = new AtomicInteger();
    private final AtomicInteger writes_blocked = new AtomicInteger();
    private final AtomicInteger inflight_breached = new AtomicInteger();
    private final AtomicInteger pending_breached = new AtomicInteger();
    private final TimerTask flush_timer = new TimerTask(){

        public void run(Timeout timeout) {
            RegionClient.this.periodicFlush();
        }

        public String toString() {
            return "flush commits of " + (Object)((Object)RegionClient.this);
        }
    };
    private final Semaphore meta_lookups = new Semaphore(100);
    private SecureRpcHelper secure_rpc_helper;
    private int inflight_limit;
    private int pending_limit;
    private int batch_size;
    private static final byte[] GET_PROTOCOL_VERSION;
    private static final byte[] GET_CLOSEST_ROW_BEFORE;
    private static final ClientPB.Column FAM_INFO;
    private static final Callback<ArrayList<KeyValue>, Object> got_closest_row_before;
    private static final byte[] HRPC3;
    private static final byte SIMPLE_AUTH = 80;
    private static final byte[] HBASE;

    public RegionClient(HBaseClient hbase_client) {
        this.hbase_client = hbase_client;
        this.check_write_status = hbase_client.getConfig().getBoolean("hbase.region_client.check_channel_write_status");
        this.inflight_limit = hbase_client.getConfig().getInt("hbase.region_client.inflight_limit");
        this.pending_limit = hbase_client.getConfig().getInt("hbase.region_client.pending_limit");
        this.batch_size = hbase_client.getConfig().getInt("hbase.rpcs.batch.size");
    }

    public boolean isAlive() {
        return !this.dead;
    }

    public String getRemoteAddress() {
        return this.chan != null ? this.chan.getRemoteAddress().toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionClientStats stats() {
        RegionClient regionClient = this;
        synchronized (regionClient) {
            return new RegionClientStats(this.rpcs_sent.get(), this.rpcs_inflight != null ? this.rpcs_inflight.size() : 0, this.pending_rpcs != null ? this.pending_rpcs.size() : 0, this.rpcid.get(), this.dead, this.chan != null ? this.chan.getRemoteAddress().toString() : "", this.batched_rpcs != null ? this.batched_rpcs.size() : 0, this.rpcs_timedout.get(), this.writes_blocked.get(), this.rpc_response_timedout.get(), this.rpc_response_unknown.get(), this.inflight_breached.get(), this.pending_breached.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicFlush() {
        if (this.chan != null || this.dead) {
            MultiAction batched_rpcs;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Periodic flush timer: flushing RPCs for " + (Object)((Object)this));
            }
            RegionClient regionClient = this;
            synchronized (regionClient) {
                batched_rpcs = this.batched_rpcs;
                this.batched_rpcs = null;
            }
            if (batched_rpcs != null && batched_rpcs.size() != 0) {
                Deferred<Object> d = batched_rpcs.getDeferred();
                this.sendRpc(batched_rpcs);
            }
        }
    }

    private void scheduleNextPeriodicFlush() {
        short interval = this.hbase_client.getFlushInterval();
        if (interval > 0) {
            short adj = (short)(System.nanoTime() & 0xF0L);
            if (interval < 3 * adj) {
                adj = (short)(adj >>> 2);
            }
            if ((adj & 0x10) == 16) {
                adj = adj < interval ? (short)(-adj) : (short)(interval / -2);
            }
            this.hbase_client.newTimeout(this.flush_timer, interval + adj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Deferred<Object> flush() {
        ArrayList<Deferred<Object>> pending;
        MultiAction batched_rpcs;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            batched_rpcs = this.batched_rpcs;
            this.batched_rpcs = null;
            pending = this.getPendingRpcs();
        }
        if (pending != null && !pending.isEmpty()) {
            Deferred wait = Deferred.group(pending);
            return wait;
        }
        if (batched_rpcs == null || batched_rpcs.size() == 0) {
            return Deferred.fromResult(null);
        }
        Deferred<Object> d = batched_rpcs.getDeferred();
        this.sendRpc(batched_rpcs);
        return d;
    }

    Deferred<Object> sync() {
        this.flush();
        ArrayList<Deferred<Object>> rpcs = this.getInflightRpcs();
        if (rpcs.isEmpty()) {
            rpcs = this.getPendingRpcs();
        }
        if (rpcs == null) {
            return Deferred.fromResult(null);
        }
        Deferred sync = Deferred.group(rpcs);
        return sync;
    }

    private ArrayList<Deferred<Object>> getInflightRpcs() {
        ArrayList<Deferred<Object>> inflight = new ArrayList<Deferred<Object>>();
        for (HBaseRpc rpc : this.rpcs_inflight.values()) {
            inflight.add(rpc.getDeferred());
        }
        return inflight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Deferred<Object>> getPendingRpcs() {
        RegionClient regionClient = this;
        synchronized (regionClient) {
            if (this.pending_rpcs != null) {
                ArrayList<Deferred<Object>> pending = new ArrayList<Deferred<Object>>(this.pending_rpcs.size());
                for (HBaseRpc rpc : this.pending_rpcs) {
                    pending.add(rpc.getDeferred());
                }
                return pending;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> shutdown() {
        final class RetryShutdown<T>
        implements Callback<Deferred<Object>, T> {
            private final int nrpcs;

            RetryShutdown(int nrpcs) {
                this.nrpcs = nrpcs;
            }

            public Deferred<Object> call(T ignored) {
                return RegionClient.this.shutdown();
            }

            public String toString() {
                return "wait until " + this.nrpcs + " RPCs complete";
            }
        }
        MultiAction batched_rpcs;
        ArrayList<Deferred<Object>> inflight = this.getInflightRpcs();
        int size = inflight.size();
        if (size > 0) {
            return Deferred.group(inflight).addCallbackDeferring(new RetryShutdown(size));
        }
        RegionClient regionClient = this;
        synchronized (regionClient) {
            batched_rpcs = this.batched_rpcs;
            this.batched_rpcs = null;
        }
        if (batched_rpcs != null && batched_rpcs.size() != 0) {
            Deferred<Object> d = batched_rpcs.getDeferred();
            this.sendRpc(batched_rpcs);
            return d.addCallbackDeferring(new RetryShutdown(1));
        }
        ArrayList<Deferred<Object>> pending = this.getPendingRpcs();
        if (pending != null) {
            return Deferred.group(pending).addCallbackDeferring(new RetryShutdown(pending.size()));
        }
        Channel chancopy = this.chan;
        if (chancopy == null) {
            return Deferred.fromResult(null);
        }
        LOG.debug("Shutdown requested, chan={}", (Object)chancopy);
        if (chancopy.isConnected()) {
            Channels.disconnect((Channel)chancopy);
        }
        if (chancopy.isBound()) {
            Channels.unbind((Channel)chancopy);
        }
        ChannelFuture future = Channels.close((Channel)chancopy);
        final Deferred d = new Deferred();
        if (future.isSuccess()) {
            d.callback(null);
        } else {
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        d.callback(null);
                        return;
                    }
                    Throwable t = future.getCause();
                    if (t instanceof Exception) {
                        d.callback((Object)t);
                    } else {
                        d.callback((Object)new NonRecoverableException("Failed to shutdown: " + (Object)((Object)RegionClient.this), t));
                    }
                }
            });
        }
        return d;
    }

    void becomeReady(Channel chan, byte server_version) {
        this.server_version = server_version;
        this.chan = chan;
        this.sendQueuedRpcs();
    }

    boolean acquireMetaLookupPermit() {
        try {
            return this.meta_lookups.tryAcquire(5L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void releaseMetaLookupPermit() {
        this.meta_lookups.release();
    }

    public Deferred<ArrayList<KeyValue>> getClosestRowBefore(RegionInfo region, final byte[] tabl, final byte[] row, final byte[] family) {
        final class GetClosestRowBefore
        extends HBaseRpc {
            GetClosestRowBefore() {
                super(byArray, byArray2);
            }

            @Override
            byte[] method(byte server_version) {
                return server_version >= 95 ? GetRequest.GGET : GET_CLOSEST_ROW_BEFORE;
            }

            @Override
            Object deserialize(ChannelBuffer buf, int cell_size) {
                assert (cell_size == 0) : "cell_size=" + cell_size;
                ClientPB.GetResponse resp = GetClosestRowBefore.readProtobuf(buf, ClientPB.GetResponse.PARSER);
                return GetRequest.extractResponse(resp, buf, cell_size);
            }

            @Override
            ChannelBuffer serialize(byte server_version) {
                if (server_version < 95) {
                    return this.serializeOld(server_version);
                }
                ClientPB.Get getpb = ClientPB.Get.newBuilder().setRow(Bytes.wrap(row)).addColumn(FAM_INFO).setClosestRowBefore(true).build();
                ClientPB.GetRequest get = ClientPB.GetRequest.newBuilder().setRegion(this.region.toProtobuf()).setGet(getpb).build();
                return GetClosestRowBefore.toChannelBuffer(GetRequest.GGET, (AbstractMessageLite)get);
            }

            private ChannelBuffer serializeOld(byte server_version) {
                byte[] region_name = this.region.name();
                ChannelBuffer buf = this.newBuffer(server_version, 7 + region_name.length + 1 + 4 + row.length + 1 + 1 + family.length);
                buf.writeInt(3);
                GetClosestRowBefore.writeHBaseByteArray(buf, region_name);
                GetClosestRowBefore.writeHBaseByteArray(buf, row);
                GetClosestRowBefore.writeHBaseByteArray(buf, family);
                return buf;
            }
        }
        GetClosestRowBefore rpc = new GetClosestRowBefore();
        rpc.setRegion(region);
        Deferred d = rpc.getDeferred().addCallback(got_closest_row_before);
        this.sendRpc(rpc);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferEdit(BatchableRpc request) {
        MultiAction batch;
        boolean schedule_flush = false;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            if (this.batched_rpcs == null) {
                this.batched_rpcs = new MultiAction();
                this.addMultiActionCallbacks(this.batched_rpcs);
                schedule_flush = true;
            }
            batch = this.batched_rpcs;
            batch.add(request);
            if (batch.size() < this.batch_size) {
                batch = null;
            } else {
                this.batched_rpcs = new MultiAction();
                this.addMultiActionCallbacks(this.batched_rpcs);
            }
        }
        if (schedule_flush) {
            this.scheduleNextPeriodicFlush();
        } else if (batch != null) {
            this.sendRpc(batch);
        }
    }

    private void addMultiActionCallbacks(final MultiAction request) {
        final class MultiActionCallback
        implements Callback<Object, Object> {
            MultiActionCallback() {
            }

            public Object call(Object resp) {
                if (!(resp instanceof MultiAction.Response)) {
                    if (resp instanceof BatchableRpc) {
                        return null;
                    }
                    if (resp instanceof Exception) {
                        return this.handleException((Exception)resp);
                    }
                    throw new InvalidResponseException(MultiAction.Response.class, resp);
                }
                MultiAction.Response response = (MultiAction.Response)resp;
                ArrayList<BatchableRpc> batch = request.batch();
                int n = batch.size();
                for (int i = 0; i < n; ++i) {
                    BatchableRpc rpc = batch.get(i);
                    Object r = response.result(i);
                    if (r instanceof RecoverableException) {
                        if (r instanceof NotServingRegionException) {
                            RegionClient.this.hbase_client.handleNSRE(rpc, rpc.getRegion().name(), (NotServingRegionException)r);
                            continue;
                        }
                        RegionClient.this.retryEdit(rpc, (RecoverableException)r);
                        continue;
                    }
                    rpc.callback(r);
                }
                return null;
            }

            private Object handleException(Exception e) {
                if (!(e instanceof RecoverableException)) {
                    for (BatchableRpc rpc : request.batch()) {
                        rpc.callback(e);
                    }
                    return e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Multi-action request failed, retrying each of the " + request.size() + " RPCs individually.", (Throwable)e);
                }
                for (BatchableRpc rpc : request.batch()) {
                    RegionClient.this.retryEdit(rpc, (RecoverableException)e);
                }
                return null;
            }

            public String toString() {
                return "multi-action response";
            }
        }
        request.getDeferred().addBoth((Callback)new MultiActionCallback());
    }

    private Deferred<Object> retryEdit(BatchableRpc rpc, RecoverableException e) {
        if (this.hbase_client.cannotRetryRequest(rpc)) {
            return HBaseClient.tooManyAttempts(rpc, e);
        }
        rpc.setBufferable(false);
        return this.hbase_client.sendRpcToRegion(rpc);
    }

    private void addSingleEditCallbacks(final BatchableRpc edit) {
        final class SingleEditErrback
        implements Callback<Object, Exception> {
            SingleEditErrback() {
            }

            public Object call(Exception e) {
                if (!(e instanceof RecoverableException)) {
                    return e;
                }
                return RegionClient.this.retryEdit(edit, (RecoverableException)e);
            }

            public String toString() {
                return "single-edit errback";
            }
        }
        edit.getDeferred().addErrback((Callback)new SingleEditErrback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRpc(HBaseRpc rpc) {
        boolean dead;
        if (this.chan != null) {
            if (rpc instanceof BatchableRpc && (this.server_version >= 29 || rpc instanceof PutRequest)) {
                BatchableRpc edit = (BatchableRpc)rpc;
                if (edit.canBuffer() && this.hbase_client.getFlushInterval() > 0) {
                    this.bufferEdit(edit);
                    return;
                }
                this.addSingleEditCallbacks(edit);
            } else if (rpc instanceof MultiAction) {
                MultiAction batch = (MultiAction)rpc;
                if (batch.size() == 1) {
                    rpc = this.multiActionToSingleAction(batch);
                } else {
                    this.hbase_client.num_multi_rpcs.increment();
                }
            }
            ChannelBuffer serialized = this.encode(rpc);
            if (serialized == null) {
                return;
            }
            Channel chan = this.chan;
            if (chan != null) {
                if (this.check_write_status && !chan.isWritable()) {
                    rpc.callback(new PleaseThrottleException("Region client [" + (Object)((Object)this) + " ] channel is not writeable.", null, rpc, rpc.getDeferred()));
                    this.removeRpc(rpc, false);
                    this.writes_blocked.incrementAndGet();
                    return;
                }
                rpc.enqueueTimeout(this);
                Channels.write((Channel)chan, (Object)serialized);
                this.rpcs_sent.incrementAndGet();
                return;
            }
        }
        boolean tryagain = false;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            dead = this.dead;
            if (this.chan != null) {
                tryagain = true;
            } else if (!dead) {
                if (this.pending_rpcs == null) {
                    this.pending_rpcs = new ArrayList();
                }
                if (this.pending_limit > 0 && this.pending_rpcs.size() >= this.pending_limit) {
                    rpc.callback(new PleaseThrottleException("Exceeded the pending RPC limit", null, rpc, rpc.getDeferred()));
                    this.pending_breached.incrementAndGet();
                    return;
                }
                this.pending_rpcs.add(rpc);
            }
        }
        if (dead) {
            if (rpc.getRegion() == null || rpc.failfast()) {
                rpc.callback(new ConnectionResetException(null));
            } else {
                this.hbase_client.sendRpcToRegion(rpc);
            }
            return;
        }
        if (tryagain) {
            this.sendRpc(rpc);
            return;
        }
        LOG.debug("RPC queued: {}", (Object)rpc);
    }

    private BatchableRpc multiActionToSingleAction(final MultiAction batch) {
        final BatchableRpc rpc = batch.batch().get(0);
        this.addSingleEditCallbacks(rpc);
        final class Multi2SingleCB
        implements Callback<Object, Object> {
            Multi2SingleCB() {
            }

            public Object call(Object arg) {
                batch.callback(arg instanceof Exception ? arg : rpc);
                return arg;
            }
        }
        rpc.getDeferred().addBoth((Callback)new Multi2SingleCB());
        return rpc;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel chan = e.getChannel();
        if (this.hbase_client.getConfig().getBoolean("hbase.security.auth.enable") && this.hbase_client.getConfig().hasProperty("hbase.security.auth.94")) {
            this.secure_rpc_helper = new SecureRpcHelper94(this.hbase_client, this, chan.getRemoteAddress());
            this.secure_rpc_helper.sendHello(chan);
            LOG.info("Initialized security helper: " + this.secure_rpc_helper + " for region client: " + (Object)((Object)this));
        } else {
            if (!this.hbase_client.has_root) {
                if (this.hbase_client.getConfig().getBoolean("hbase.security.auth.enable")) {
                    this.secure_rpc_helper = new SecureRpcHelper96(this.hbase_client, this, chan.getRemoteAddress());
                    this.secure_rpc_helper.sendHello(chan);
                    LOG.info("Initialized security helper: " + this.secure_rpc_helper + " for region client: " + (Object)((Object)this));
                    return;
                }
                ChannelBuffer header = this.header095();
                Channels.write((Channel)chan, (Object)header);
                this.becomeReady(chan, (byte)95);
                return;
            }
            ChannelBuffer header = System.getProperty("org.hbase.async.cdh3b3") != null ? this.headerCDH3b3() : this.header090();
            this.helloRpc(chan, header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedRpcs() {
        ArrayList<HBaseRpc> rpcs;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            rpcs = this.pending_rpcs;
            this.pending_rpcs = null;
        }
        if (rpcs != null) {
            for (HBaseRpc rpc : rpcs) {
                LOG.debug("Executing RPC queued: {}", (Object)rpc);
                this.sendRpc(rpc);
            }
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.chan = null;
        super.channelDisconnected(ctx, e);
        this.cleanup(e.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.chan = null;
        this.cleanup(e.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Channel chan) {
        MultiAction batch;
        ArrayList<HBaseRpc> rpcs;
        ConnectionResetException exception = new ConnectionResetException(chan);
        this.failOrRetryRpcs(this.rpcs_inflight.values(), exception);
        this.rpcs_inflight.clear();
        RegionClient regionClient = this;
        synchronized (regionClient) {
            this.dead = true;
            rpcs = this.pending_rpcs;
            this.pending_rpcs = null;
            batch = this.batched_rpcs;
            this.batched_rpcs = null;
        }
        if (rpcs != null) {
            this.failOrRetryRpcs(rpcs, exception);
        }
        if (batch != null) {
            batch.callback(exception);
        }
    }

    private void failOrRetryRpcs(Collection<HBaseRpc> rpcs, ConnectionResetException exception) {
        for (HBaseRpc rpc : rpcs) {
            RegionInfo region = rpc.getRegion();
            if (region == null || rpc.failfast()) {
                rpc.callback(exception);
                continue;
            }
            NotServingRegionException nsre = new NotServingRegionException("Connection reset: " + exception.getMessage(), rpc);
            this.hbase_client.handleNSRE(rpc, region.name(), nsre);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleUpstream {}", (Object)e);
        }
        super.handleUpstream(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable e = event.getCause();
        Channel c = event.getChannel();
        if (e instanceof RejectedExecutionException) {
            LOG.warn("RPC rejected by the executor, ignore this if we're shutting down", e);
        } else {
            LOG.error("Unexpected exception from downstream on " + c, e);
        }
        if (c.isOpen()) {
            Channels.close((Channel)c);
        } else {
            this.cleanup(c);
        }
    }

    private ChannelBuffer encode(HBaseRpc rpc) {
        ChannelBuffer payload;
        block13: {
            if (!rpc.hasDeferred()) {
                throw new AssertionError((Object)("Should never happen!  rpc=" + rpc));
            }
            rpc.rpc_id = this.rpcid.incrementAndGet();
            try {
                payload = rpc.serialize(this.server_version);
                byte[] method = rpc.method(this.server_version);
                if (this.server_version >= 95) {
                    RPCPB.RequestHeader header = RPCPB.RequestHeader.newBuilder().setCallId(rpc.rpc_id).setMethodNameBytes(Bytes.wrap(method)).setRequestParam(true).build();
                    int pblen = header.getSerializedSize();
                    int offset = 19 + method.length - pblen - 1;
                    assert (offset >= 0) : "RPC header too big (" + pblen + " bytes): " + header;
                    payload.readerIndex(offset);
                    payload.setInt(offset, payload.readableBytes() - 4);
                    try {
                        CodedOutputStream output = CodedOutputStream.newInstance((byte[])payload.array(), (int)(4 + offset), (int)(1 + pblen));
                        output.writeRawByte(pblen);
                        header.writeTo(output);
                        output.checkNoSpaceLeft();
                        break block13;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Should never happen", e);
                    }
                }
                if (this.server_version >= 29) {
                    payload.setInt(0, payload.readableBytes() - 4);
                    payload.setInt(4, rpc.rpc_id);
                    payload.setByte(8, 1);
                    payload.setShort(9, method.length);
                    payload.setBytes(11, method);
                    payload.setLong(11 + method.length, (long)this.server_version);
                } else {
                    payload.setInt(0, payload.readableBytes() - 4);
                    payload.setInt(4, rpc.rpc_id);
                    payload.setShort(8, method.length);
                    payload.setBytes(10, method);
                }
            }
            catch (Exception e) {
                LOG.error("Uncaught exception while serializing RPC: " + rpc, (Throwable)e);
                rpc.callback(e);
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.chan + " Sending RPC #" + this.rpcid + ", payload=" + payload + ' ' + Bytes.pretty(payload));
        }
        if (this.inflight_limit > 0 && this.rpcs_inflight.size() >= this.inflight_limit) {
            rpc.callback(new PleaseThrottleException("Exceeded the inflight RPC limit", null, rpc, rpc.getDeferred()));
            this.inflight_breached.incrementAndGet();
            return null;
        }
        HBaseRpc oldrpc = this.rpcs_inflight.put(rpc.rpc_id, rpc);
        if (oldrpc != null) {
            String wtf = "WTF?  There was already an RPC in flight with rpcid=" + this.rpcid + ": " + oldrpc + ".  This happened when sending out: " + rpc;
            LOG.error(wtf);
            oldrpc.callback(new NonRecoverableException(wtf));
        }
        if (this.secure_rpc_helper != null) {
            payload = this.secure_rpc_helper.wrap(payload);
        }
        return payload;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel chan, ChannelBuffer channel_buffer, VoidEnum unused) {
        Object decoded;
        int rpcid;
        RPCPB.ResponseHeader header;
        int size;
        ChannelBuffer buf = channel_buffer;
        long start = System.nanoTime();
        int rdx = buf.readerIndex();
        LOG.debug("------------------>> ENTERING DECODE >>------------------");
        if (this.secure_rpc_helper != null && (buf = this.secure_rpc_helper.handleResponse(buf, chan)) == null) {
            return null;
        }
        if (this.server_version >= 95) {
            size = buf.readInt();
            RegionClient.ensureReadable(buf, size);
            HBaseRpc.checkArrayLength(buf, size);
            header = HBaseRpc.readProtobuf(buf, RPCPB.ResponseHeader.PARSER);
            if (!header.hasCallId()) {
                String msg = "RPC response (size: " + size + ") doesn't" + " have a call ID: " + header + ", buf=" + Bytes.pretty(buf);
                throw new NonRecoverableException(msg);
            }
            rpcid = header.getCallId();
        } else {
            size = 0;
            header = null;
            rpcid = buf.readInt();
        }
        HBaseRpc rpc = this.rpcs_inflight.remove(rpcid);
        if (rpc == null) {
            if (rpcid > -1 && rpcid <= this.rpcid.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received a response for rpcid: " + rpcid + " that is no longer in our inflight map on region client " + (Object)((Object)this) + ". It may have been evicted. buf=" + Bytes.pretty(buf));
                }
                this.rpc_response_timedout.incrementAndGet();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received rpcid: " + rpcid + " that doesn't seem to be a " + "valid ID on region client " + (Object)((Object)this) + ". This packet may have " + "been corrupted. buf=" + Bytes.pretty(buf));
                }
                this.rpc_response_unknown.incrementAndGet();
            }
            buf.readerIndex(rdx + size + 4);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped timed out RPC ID " + rpcid + " of " + size + " bytes on " + (Object)((Object)this));
            }
            return null;
        }
        assert (rpc.rpc_id == rpcid);
        try {
            if (this.server_version >= 95) {
                if (header.hasException()) {
                    decoded = RegionClient.decodeException(rpc, header.getException());
                } else {
                    int cell_size;
                    RPCPB.CellBlockMeta cellblock = header.getCellBlockMeta();
                    if (cellblock == null) {
                        cell_size = 0;
                    } else {
                        cell_size = cellblock.getLength();
                        HBaseRpc.checkArrayLength(buf, cell_size);
                    }
                    decoded = rpc.deserialize(buf, cell_size);
                }
            } else {
                decoded = this.deserialize(buf, rpc);
            }
        }
        catch (RuntimeException e2) {
            NonRecoverableException e2;
            String msg = "Uncaught error during de-serialization of " + rpc + ", rpcid=" + rpcid;
            LOG.error(msg);
            if (!(e2 instanceof HBaseException)) {
                e2 = new NonRecoverableException(msg, e2);
            }
            rpc.callback(e2);
            throw e2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rpcid=" + rpcid + ", response size=" + (buf.readerIndex() - rdx) + " bytes" + ", " + this.actualReadableBytes() + " readable bytes left" + ", rpc=" + rpc);
        }
        if (decoded instanceof NotServingRegionException && rpc.getRegion() != null) {
            this.hbase_client.handleNSRE(rpc, rpc.getRegion().name(), (RecoverableException)decoded);
            return null;
        }
        try {
            rpc.callback(decoded);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while handling RPC #" + rpcid + ", rpc=" + rpc + ", buf=" + Bytes.pretty(buf), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------------<< LEAVING  DECODE <<------------------ time elapsed: " + (System.nanoTime() - start) / 1000L + "us");
        }
        return null;
    }

    private static void ensureReadable(ChannelBuffer buf, int nbytes) {
        buf.markReaderIndex();
        buf.skipBytes(nbytes);
        buf.resetReaderIndex();
    }

    private Object deserialize(ChannelBuffer buf, HBaseRpc rpc) {
        int flags = this.secure_rpc_helper != null ? buf.readInt() : (int)buf.readByte();
        if ((flags & 2) != 0) {
            int length = buf.readInt() - 4 - 1 - 4 - 4;
            int status = buf.readInt();
            try {
                HBaseRpc.checkArrayLength(buf, length);
                RegionClient.ensureReadable(buf, length);
            }
            catch (IllegalArgumentException e) {
                LOG.error("WTF?  RPC #" + this.rpcid + ": ", (Throwable)e);
            }
        }
        if ((flags & 1) != 0) {
            return RegionClient.deserializeException(buf, rpc);
        }
        try {
            return RegionClient.deserializeObject(buf, rpc);
        }
        catch (IllegalArgumentException e) {
            return new InvalidResponseException(e.getMessage(), e);
        }
    }

    static HBaseException deserializeException(ChannelBuffer buf, HBaseRpc request) {
        String type = HBaseRpc.readHadoopString(buf);
        String msg = HBaseRpc.readHadoopString(buf);
        return RegionClient.makeException(request, type, msg);
    }

    private static final HBaseException makeException(HBaseRpc request, String type, String msg) {
        HBaseException exc = REMOTE_EXCEPTION_TYPES.get(type);
        if (exc != null) {
            return exc.make(msg, request);
        }
        return new RemoteException(type, msg);
    }

    private static HBaseException decodeException(HBaseRpc request, RPCPB.ExceptionResponse e) {
        String type = e.hasExceptionClassName() ? e.getExceptionClassName() : "(missing exception type)";
        return RegionClient.makeException(request, type, e.getStackTrace());
    }

    static HBaseException decodeExceptionPair(HBaseRpc request, HBasePB.NameBytesPair pair) {
        String stacktrace = pair.hasValue() ? pair.getValue().toStringUtf8() : "(missing server-side stack trace)";
        return RegionClient.makeException(request, pair.getName(), stacktrace);
    }

    static Object deserializeObject(ChannelBuffer buf, HBaseRpc request) {
        switch (buf.readByte()) {
            case 1: {
                return buf.readByte() != 0;
            }
            case 6: {
                return buf.readLong();
            }
            case 14: {
                return RegionClient.deserializeObject(buf, request);
            }
            case 17: {
                buf.readByte();
                return null;
            }
            case 37: {
                buf.readByte();
                return RegionClient.parseResult(buf);
            }
            case 38: {
                return RegionClient.parseResults(buf);
            }
            case 58: 
            case 67: {
                return ((MultiAction)request).responseFromBuffer(buf);
            }
        }
        throw new NonRecoverableException("Couldn't de-serialize " + Bytes.pretty(buf));
    }

    static int numberOfKeyValuesAhead(ChannelBuffer buf, int length) {
        int kv_length;
        int offset;
        RegionClient.ensureReadable(buf, length);
        int num_kv = 0;
        length += offset;
        for (offset = buf.readerIndex(); offset < length; offset += kv_length + 4) {
            kv_length = buf.getInt(offset);
            HBaseRpc.checkArrayLength(buf, kv_length);
            ++num_kv;
        }
        if (offset != length) {
            int index = buf.readerIndex();
            RegionClient.badResponse("We wanted read " + (length - index) + " bytes but we read " + (offset - index) + " from " + buf + '=' + Bytes.pretty(buf));
        }
        return num_kv;
    }

    private static ArrayList<KeyValue> parseResult(ChannelBuffer buf) {
        int length = buf.readInt();
        HBaseRpc.checkArrayLength(buf, length);
        int num_kv = RegionClient.numberOfKeyValuesAhead(buf, length);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>(num_kv);
        KeyValue kv = null;
        for (int i = 0; i < num_kv; ++i) {
            int kv_length = buf.readInt();
            int key_length = 2 + (kv = KeyValue.fromBuffer(buf, kv)).key().length + 1 + kv.family().length + kv.qualifier().length + 8 + 1;
            if (key_length + kv.value().length + 4 + 4 != kv_length) {
                RegionClient.badResponse("kv_length=" + kv_length + " doesn't match key_length + value_length (" + key_length + " + " + kv.value().length + ") in " + buf + '=' + Bytes.pretty(buf));
            }
            results.add(kv);
        }
        return results;
    }

    private static ArrayList<ArrayList<KeyValue>> parseResults(ChannelBuffer buf) {
        int nresults;
        byte version = buf.readByte();
        if (version != 1) {
            LOG.warn("Received unsupported Result[] version: " + version);
        }
        if ((nresults = buf.readInt()) < 0) {
            RegionClient.badResponse("Negative number of results=" + nresults + " found in " + buf + '=' + Bytes.pretty(buf));
        } else if (nresults == 0) {
            return null;
        }
        int length = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, length);
        RegionClient.ensureReadable(buf, length);
        ArrayList<ArrayList<KeyValue>> results = new ArrayList<ArrayList<KeyValue>>(nresults);
        int bytes_read = 0;
        for (int i = 0; i < nresults; ++i) {
            int num_kv = buf.readInt();
            bytes_read += 4;
            if (num_kv < 0) {
                RegionClient.badResponse("Negative number of KeyValues=" + num_kv + " for Result[" + i + "] found in " + buf + '=' + Bytes.pretty(buf));
            } else if (nresults == 0) continue;
            ArrayList<KeyValue> result = new ArrayList<KeyValue>(num_kv);
            KeyValue kv = null;
            for (int j = 0; j < num_kv; ++j) {
                int kv_length = buf.readInt();
                HBaseRpc.checkNonEmptyArrayLength(buf, kv_length);
                kv = KeyValue.fromBuffer(buf, kv);
                result.add(kv);
                bytes_read += 4 + kv_length;
            }
            results.add(result);
        }
        if (length != bytes_read) {
            RegionClient.badResponse("Result[" + nresults + "] was supposed to be " + length + " bytes, but we only read " + bytes_read + " bytes from " + buf + '=' + Bytes.pretty(buf));
        }
        return results;
    }

    private static void badResponse(String errmsg) {
        LOG.error(errmsg);
        throw new InvalidResponseException(errmsg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decodeLast(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum unused) {
        if (buf.readable()) {
            try {
                Object object = this.decode(ctx, chan, buf, unused);
                return object;
            }
            finally {
                if (buf.readable()) {
                    LOG.error("After decoding the last message on " + chan + ", there was still some undecoded bytes in the channel's" + " buffer (which are going to be lost): " + buf + '=' + Bytes.pretty(buf));
                }
            }
        }
        return null;
    }

    HBaseRpc removeRpc(HBaseRpc rpc, boolean timedout) {
        HBaseRpc old_rpc = this.rpcs_inflight.remove(rpc.rpc_id);
        if (old_rpc != rpc) {
            LOG.error("Removed the wrong RPC " + old_rpc + " when we meant to remove " + rpc);
            if (old_rpc != null) {
                old_rpc.callback(new NonRecoverableException("Removed the wrong RPC from client " + (Object)((Object)this)));
            }
        }
        if (timedout) {
            this.rpcs_timedout.incrementAndGet();
        }
        return old_rpc;
    }

    HBaseClient getHBaseClient() {
        return this.hbase_client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int nedits;
        int npending_rpcs;
        StringBuilder buf = new StringBuilder(141);
        buf.append("RegionClient@").append(((Object)((Object)this)).hashCode()).append("(chan=").append(this.chan).append(", #pending_rpcs=");
        RegionClient regionClient = this;
        synchronized (regionClient) {
            npending_rpcs = this.pending_rpcs == null ? 0 : this.pending_rpcs.size();
            nedits = this.batched_rpcs == null ? 0 : this.batched_rpcs.size();
        }
        buf.append(npending_rpcs).append(", #batched=").append(nedits);
        buf.append(", #rpcs_inflight=").append(this.rpcs_inflight.size()).append(')');
        return buf.toString();
    }

    private ChannelBuffer commonHeader(byte[] buf, byte[] hrpc) {
        ChannelBuffer header = ChannelBuffers.wrappedBuffer((byte[])buf);
        header.clear();
        header.writeBytes(hrpc);
        return header;
    }

    private ChannelBuffer header095() {
        RPCPB.UserInformation user = RPCPB.UserInformation.newBuilder().setEffectiveUser(System.getProperty("user.name", "asynchbase")).build();
        RPCPB.ConnectionHeader pb = RPCPB.ConnectionHeader.newBuilder().setUserInfo(user).setServiceName("ClientService").setCellBlockCodecClass("org.apache.hadoop.hbase.codec.KeyValueCodec").build();
        int pblen = pb.getSerializedSize();
        byte[] buf = new byte[HBASE.length + 4 + pblen];
        ChannelBuffer header = this.commonHeader(buf, HBASE);
        header.writeInt(pblen);
        try {
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])buf, (int)(HBASE.length + 4), (int)pblen);
            pb.writeTo(output);
            output.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
        header.writerIndex(buf.length);
        return header;
    }

    private ChannelBuffer header092() {
        byte[] buf = new byte[54];
        ChannelBuffer header = this.commonHeader(buf, HRPC3);
        header.writerIndex(header.writerIndex() + 4);
        String klass = "org.apache.hadoop.hbase.ipc.HRegionInterface";
        header.writeByte("org.apache.hadoop.hbase.ipc.HRegionInterface".length());
        header.writeBytes(Bytes.ISO88591("org.apache.hadoop.hbase.ipc.HRegionInterface"));
        header.setInt(5, header.writerIndex() - 4 - 5);
        return header;
    }

    private ChannelBuffer header090() {
        byte[] buf = new byte[139];
        ChannelBuffer header = this.commonHeader(buf, HRPC3);
        header.writerIndex(header.writerIndex() + 4);
        String klass = "org.apache.hadoop.io.Writable";
        header.writeShort(klass.length());
        header.writeBytes(Bytes.ISO88591(klass));
        klass = "org.apache.hadoop.io.ObjectWritable$NullInstance";
        header.writeShort(klass.length());
        header.writeBytes(Bytes.ISO88591(klass));
        klass = "org.apache.hadoop.security.UserGroupInformation";
        header.writeShort(klass.length());
        header.writeBytes(Bytes.ISO88591(klass));
        header.setInt(5, header.writerIndex() - 4 - 5);
        return header;
    }

    private ChannelBuffer headerCDH3b3() {
        byte[] user = Bytes.UTF8(System.getProperty("user.name", "asynchbase"));
        byte[] buf = new byte[13 + user.length];
        ChannelBuffer header = this.commonHeader(buf, HRPC3);
        header.writeInt(4 + user.length);
        header.writeInt(user.length);
        header.writeBytes(user);
        return header;
    }

    private void helloRpc(final Channel chan, ChannelBuffer header) {
        LOG.debug("helloRpc for the channel: {}", (Object)chan);
        Callback<Object, Exception> errorback = new Callback<Object, Exception>(){

            public Object call(Exception e) throws Exception {
                LOG.info("helloRpc failed. Closing the channel:" + chan, (Throwable)e);
                Channels.close((Channel)chan);
                return e;
            }
        };
        GetProtocolVersionRequest rpc = new GetProtocolVersionRequest();
        rpc.getDeferred().addBoth((Callback)new ProtocolVersionCB(chan)).addErrback((Callback)errorback);
        Channels.write((Channel)chan, (Object)ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, this.encode(rpc)}));
    }

    void sendVersion(Channel chan) {
        GetProtocolVersionRequest rpc = new GetProtocolVersionRequest();
        rpc.getDeferred().addBoth((Callback)new ProtocolVersionCB(chan));
        Channels.write((Channel)chan, (Object)this.encode(rpc));
    }

    static {
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException", new NoSuchColumnFamilyException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.NotServingRegionException", new NotServingRegionException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.exceptions.RegionMovedException", new RegionMovedException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.exceptions.RegionOpeningException", new RegionOpeningException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.UnknownScannerException", new UnknownScannerException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.UnknownRowLockException", new UnknownRowLockException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.io.VersionMismatchException", new VersionMismatchException(null, null));
        GET_PROTOCOL_VERSION = new byte[]{103, 101, 116, 80, 114, 111, 116, 111, 99, 111, 108, 86, 101, 114, 115, 105, 111, 110};
        GET_CLOSEST_ROW_BEFORE = new byte[]{103, 101, 116, 67, 108, 111, 115, 101, 115, 116, 82, 111, 119, 66, 101, 102, 111, 114, 101};
        FAM_INFO = ClientPB.Column.newBuilder().setFamily(Bytes.wrap(HBaseClient.INFO)).build();
        got_closest_row_before = new Callback<ArrayList<KeyValue>, Object>(){

            public ArrayList<KeyValue> call(Object response) {
                if (response == null) {
                    return new ArrayList<KeyValue>(0);
                }
                if (response instanceof ArrayList) {
                    ArrayList row = (ArrayList)response;
                    return row;
                }
                throw new InvalidResponseException(ArrayList.class, response);
            }

            public String toString() {
                return "type getClosestRowBefore response";
            }
        };
        HRPC3 = new byte[]{104, 114, 112, 99, 3};
        HBASE = new byte[]{72, 66, 97, 115, 0, 80};
    }

    final class RetryRpc<T>
    implements Callback<T, T> {
        private final HBaseRpc rpc;

        RetryRpc(HBaseRpc rpc) {
            this.rpc = rpc;
        }

        public T call(T arg) {
            RegionClient.this.sendRpc(this.rpc);
            return arg;
        }
    }

    private final class ProtocolVersionCB
    implements Callback<Long, Object> {
        private final Channel chan;

        public ProtocolVersionCB(Channel chan) {
            this.chan = chan;
        }

        public Long call(Object response) throws Exception {
            if (response instanceof VersionMismatchException) {
                if (RegionClient.this.server_version != 0) {
                    throw (VersionMismatchException)response;
                }
                RegionClient.this.server_version = (byte)29;
                RegionClient.this.helloRpc(this.chan, RegionClient.this.header092());
                return null;
            }
            if (!(response instanceof Long)) {
                if (response instanceof Exception) {
                    throw (Exception)response;
                }
                throw new InvalidResponseException(Long.class, response);
            }
            Long version = (Long)response;
            long v = version;
            if (v <= 0L || v > 127L) {
                throw new InvalidResponseException("getProtocolVersion returned a " + (v <= 0L ? "negative" : "too large") + " value", (Object)version);
            }
            RegionClient.this.becomeReady(this.chan, (byte)v);
            return version;
        }

        public String toString() {
            return "handle getProtocolVersion response on " + this.chan;
        }
    }

    private static final class GetProtocolVersionRequest
    extends HBaseRpc {
        private GetProtocolVersionRequest() {
        }

        @Override
        byte[] method(byte unused_server_version) {
            return GET_PROTOCOL_VERSION;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 59);
            buf.writeInt(2);
            GetProtocolVersionRequest.writeHBaseString(buf, "org.apache.hadoop.hbase.ipc.HRegionInterface");
            GetProtocolVersionRequest.writeHBaseLong(buf, server_version == 0 ? 24L : (long)server_version);
            return buf;
        }

        @Override
        Object deserialize(ChannelBuffer buf, int cell_size) {
            throw new AssertionError((Object)"Should never be here.");
        }
    }
}

