/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
public abstract class FieldPartitioner<S, T>
implements Function<S, T>,
Comparator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldPartitioner.class);
    public static final int UNKNOWN_CARDINALITY = -1;
    private final String sourceName;
    private final String name;
    private final Class<S> sourceType;
    private final Class<T> type;
    private final int cardinality;

    protected FieldPartitioner(String sourceName, String name, Class<S> sourceType, Class<T> type) {
        this(sourceName, name, sourceType, type, -1);
    }

    protected FieldPartitioner(String sourceName, String name, Class<S> sourceType, Class<T> type, int cardinality) {
        this.sourceName = sourceName;
        this.name = name;
        this.sourceType = sourceType;
        this.type = type;
        this.cardinality = cardinality;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public abstract T apply(S var1);

    public Class<S> getSourceType() {
        return this.sourceType;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<? extends T> getType(Class<? extends S> sourceType) {
        return this.getType();
    }

    public abstract Predicate<T> project(Predicate<S> var1);

    public abstract Predicate<T> projectStrict(Predicate<S> var1);
}

