/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kafka;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.instrumentation.kafka.KafkaSinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.kafka.SinkCallback;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaSink.class);
    private final Properties kafkaProps = new Properties();
    private KafkaProducer<String, byte[]> producer;
    private String topic;
    private int batchSize;
    private List<Future<RecordMetadata>> kafkaFutures;
    private KafkaSinkCounter counter;
    private boolean useAvroEventFormat;
    private String partitionHeader = null;
    private Integer staticPartitionId = null;
    private Optional<SpecificDatumWriter<AvroFlumeEvent>> writer = Optional.absent();
    private Optional<SpecificDatumReader<AvroFlumeEvent>> reader = Optional.absent();
    private Optional<ByteArrayOutputStream> tempOutStream = Optional.absent();
    private BinaryEncoder encoder = null;

    public String getTopic() {
        return this.topic;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Sink.Status process() throws EventDeliveryException {
        Sink.Status result = Sink.Status.READY;
        Channel channel = this.getChannel();
        Transaction transaction = null;
        Event event = null;
        String eventTopic = null;
        String eventKey = null;
        try {
            long processedEvents;
            transaction = channel.getTransaction();
            transaction.begin();
            this.kafkaFutures.clear();
            long batchStartTime = System.nanoTime();
            for (processedEvents = 0L; processedEvents < (long)this.batchSize; ++processedEvents) {
                event = channel.take();
                if (event == null) {
                    if (processedEvents == 0L) {
                        result = Sink.Status.BACKOFF;
                        this.counter.incrementBatchEmptyCount();
                        break;
                    }
                    this.counter.incrementBatchUnderflowCount();
                    break;
                }
                byte[] eventBody = event.getBody();
                Map headers = event.getHeaders();
                eventTopic = (String)headers.get("topic");
                if (eventTopic == null) {
                    eventTopic = this.topic;
                }
                eventKey = (String)headers.get("key");
                if (logger.isTraceEnabled()) {
                    if (LogPrivacyUtil.allowLogRawData()) {
                        logger.trace("{Event} " + eventTopic + " : " + eventKey + " : " + new String(eventBody, "UTF-8"));
                    } else {
                        logger.trace("{Event} " + eventTopic + " : " + eventKey);
                    }
                }
                logger.debug("event #{}", (Object)processedEvents);
                long startTime = System.currentTimeMillis();
                Integer partitionId = null;
                try {
                    String headerVal;
                    if (this.staticPartitionId != null) {
                        partitionId = this.staticPartitionId;
                    }
                    if (this.partitionHeader != null && (headerVal = (String)event.getHeaders().get(this.partitionHeader)) != null) {
                        partitionId = Integer.parseInt(headerVal);
                    }
                    ProducerRecord record = partitionId != null ? new ProducerRecord(eventTopic, partitionId, (Object)eventKey, (Object)this.serializeEvent(event, this.useAvroEventFormat)) : new ProducerRecord(eventTopic, (Object)eventKey, (Object)this.serializeEvent(event, this.useAvroEventFormat));
                    this.kafkaFutures.add(this.producer.send(record, (Callback)new SinkCallback(startTime)));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new EventDeliveryException("Non integer partition id specified", (Throwable)ex);
                }
                catch (Exception ex) {
                    throw new EventDeliveryException("Could not send event", (Throwable)ex);
                }
            }
            this.producer.flush();
            if (processedEvents > 0L) {
                for (Future<RecordMetadata> future : this.kafkaFutures) {
                    future.get();
                }
                long endTime = System.nanoTime();
                this.counter.addToKafkaEventSendTimer((endTime - batchStartTime) / 1000000L);
                this.counter.addToEventDrainSuccessCount(Long.valueOf(this.kafkaFutures.size()).longValue());
            }
            transaction.commit();
        }
        catch (Exception ex) {
            String errorMsg = "Failed to publish events";
            logger.error("Failed to publish events", (Throwable)ex);
            result = Sink.Status.BACKOFF;
            if (transaction != null) {
                try {
                    this.kafkaFutures.clear();
                    transaction.rollback();
                    this.counter.incrementRollbackCount();
                }
                catch (Exception e) {
                    logger.error("Transaction rollback failed", (Throwable)e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
            throw new EventDeliveryException(errorMsg, (Throwable)ex);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        return result;
    }

    public synchronized void start() {
        this.producer = new KafkaProducer(this.kafkaProps);
        this.counter.start();
        super.start();
    }

    public synchronized void stop() {
        this.producer.close();
        this.counter.stop();
        logger.info("Kafka Sink {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.counter);
        super.stop();
    }

    public void configure(Context context) {
        this.translateOldProps(context);
        String topicStr = context.getString("kafka.topic");
        if (topicStr == null || topicStr.isEmpty()) {
            topicStr = "default-flume-topic";
            logger.warn("Topic was not specified. Using {} as the topic.", (Object)topicStr);
        } else {
            logger.info("Using the static topic {}. This may be overridden by event headers", (Object)topicStr);
        }
        this.topic = topicStr;
        this.batchSize = context.getInteger("flumeBatchSize", Integer.valueOf(100));
        if (logger.isDebugEnabled()) {
            logger.debug("Using batch size: {}", (Object)this.batchSize);
        }
        this.useAvroEventFormat = context.getBoolean("useFlumeEventFormat", Boolean.valueOf(false));
        this.partitionHeader = context.getString("partitionIdHeader");
        this.staticPartitionId = context.getInteger("defaultPartitionId");
        if (logger.isDebugEnabled()) {
            logger.debug("useFlumeEventFormat set to: {}", (Object)this.useAvroEventFormat);
        }
        this.kafkaFutures = new LinkedList<Future<RecordMetadata>>();
        String bootStrapServers = context.getString("kafka.bootstrap.servers");
        if (bootStrapServers == null || bootStrapServers.isEmpty()) {
            throw new ConfigurationException("Bootstrap Servers must be specified");
        }
        this.setProducerProps(context, bootStrapServers);
        if (logger.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
            logger.debug("Kafka producer properties: {}", (Object)this.kafkaProps);
        }
        if (this.counter == null) {
            this.counter = new KafkaSinkCounter(this.getName());
        }
    }

    private void translateOldProps(Context ctx) {
        String requiredKey;
        String oldBatchSize;
        if (!ctx.containsKey("kafka.topic")) {
            ctx.put("kafka.topic", ctx.getString("topic"));
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"topic", (Object)"kafka.topic");
        }
        if (!ctx.containsKey("kafka.bootstrap.servers")) {
            String brokerList = ctx.getString("brokerList");
            if (brokerList == null || brokerList.isEmpty()) {
                throw new ConfigurationException("Bootstrap Servers must be specified");
            }
            ctx.put("kafka.bootstrap.servers", brokerList);
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"brokerList", (Object)"kafka.bootstrap.servers");
        }
        if (!ctx.containsKey("flumeBatchSize") && (oldBatchSize = ctx.getString("batchSize")) != null && !oldBatchSize.isEmpty()) {
            ctx.put("flumeBatchSize", oldBatchSize);
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"batchSize", (Object)"flumeBatchSize");
        }
        if (!ctx.containsKey("kafka.producer.acks") && (requiredKey = ctx.getString("requiredAcks")) != null && !requiredKey.isEmpty()) {
            ctx.put("kafka.producer.acks", requiredKey);
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"requiredAcks", (Object)"kafka.producer.acks");
        }
        if (ctx.containsKey("key.serializer.class")) {
            logger.warn("{} is deprecated. Flume now uses the latest Kafka producer which implements a different interface for serializers. Please use the parameter {}", (Object)"key.serializer.class", (Object)"kafka.producer.key.serializer");
        }
        if (ctx.containsKey("serializer.class")) {
            logger.warn("{} is deprecated. Flume now uses the latest Kafka producer which implements a different interface for serializers. Please use the parameter {}", (Object)"serializer.class", (Object)"kafka.producer.value.serializer");
        }
    }

    private void setProducerProps(Context context, String bootStrapServers) {
        this.kafkaProps.put("acks", "1");
        this.kafkaProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.kafkaProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.kafkaProps.putAll((Map<?, ?>)context.getSubProperties("kafka.producer."));
        this.kafkaProps.put("bootstrap.servers", bootStrapServers);
    }

    protected Properties getKafkaProps() {
        return this.kafkaProps;
    }

    private byte[] serializeEvent(Event event, boolean useAvroEventFormat) throws IOException {
        byte[] bytes;
        if (useAvroEventFormat) {
            if (!this.tempOutStream.isPresent()) {
                this.tempOutStream = Optional.of((Object)new ByteArrayOutputStream());
            }
            if (!this.writer.isPresent()) {
                this.writer = Optional.of((Object)new SpecificDatumWriter(AvroFlumeEvent.class));
            }
            ((ByteArrayOutputStream)this.tempOutStream.get()).reset();
            AvroFlumeEvent e = new AvroFlumeEvent(KafkaSink.toCharSeqMap(event.getHeaders()), ByteBuffer.wrap(event.getBody()));
            this.encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)this.tempOutStream.get(), this.encoder);
            ((SpecificDatumWriter)this.writer.get()).write((Object)e, (Encoder)this.encoder);
            this.encoder.flush();
            bytes = ((ByteArrayOutputStream)this.tempOutStream.get()).toByteArray();
        } else {
            bytes = event.getBody();
        }
        return bytes;
    }

    private static Map<CharSequence, CharSequence> toCharSeqMap(Map<String, String> stringMap) {
        HashMap<CharSequence, CharSequence> charSeqMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            charSeqMap.put(entry.getKey(), entry.getValue());
        }
        return charSeqMap;
    }
}

