/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.jms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.conf.Configurables;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractPollableSource;
import org.apache.flume.source.jms.DefaultJMSMessageConverter;
import org.apache.flume.source.jms.InitialContextFactory;
import org.apache.flume.source.jms.JMSDestinationLocator;
import org.apache.flume.source.jms.JMSDestinationType;
import org.apache.flume.source.jms.JMSMessageConsumer;
import org.apache.flume.source.jms.JMSMessageConsumerFactory;
import org.apache.flume.source.jms.JMSMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JMSSource
extends AbstractPollableSource {
    private static final Logger logger = LoggerFactory.getLogger(JMSSource.class);
    private final JMSMessageConsumerFactory consumerFactory;
    private final InitialContextFactory initialContextFactory;
    private ConnectionFactory connectionFactory;
    private int batchSize;
    private JMSMessageConverter converter;
    private JMSMessageConsumer consumer;
    private String initialContextFactoryName;
    private String providerUrl;
    private String destinationName;
    private JMSDestinationType destinationType;
    private JMSDestinationLocator destinationLocator;
    private String messageSelector;
    private Optional<String> userName;
    private Optional<String> password;
    private SourceCounter sourceCounter;
    private int errorThreshold;
    private long pollTimeout;
    private int jmsExceptionCounter;
    private InitialContext initialContext;

    public JMSSource() {
        this(new JMSMessageConsumerFactory(), new InitialContextFactory());
    }

    @VisibleForTesting
    public JMSSource(JMSMessageConsumerFactory consumerFactory, InitialContextFactory initialContextFactory) {
        this.consumerFactory = consumerFactory;
        this.initialContextFactory = initialContextFactory;
    }

    protected void doConfigure(Context context) throws FlumeException {
        this.sourceCounter = new SourceCounter(this.getName());
        this.initialContextFactoryName = context.getString("initialContextFactory", "").trim();
        this.providerUrl = context.getString("providerURL", "").trim();
        this.destinationName = context.getString("destinationName", "").trim();
        String destinationTypeName = context.getString("destinationType", "").trim().toUpperCase(Locale.ENGLISH);
        String destinationLocatorName = context.getString("destinationLocator", "CDI").trim().toUpperCase(Locale.ENGLISH);
        this.messageSelector = context.getString("messageSelector", "").trim();
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(100));
        this.errorThreshold = context.getInteger("errorThreshold", Integer.valueOf(10));
        this.userName = Optional.fromNullable((Object)context.getString("userName"));
        this.pollTimeout = context.getLong("pollTimeout", Long.valueOf(1000L));
        String passwordFile = context.getString("passwordFile", "").trim();
        if (passwordFile.isEmpty()) {
            this.password = Optional.of((Object)"");
        } else {
            try {
                this.password = Optional.of((Object)Files.toString((File)new File(passwordFile), (Charset)Charsets.UTF_8).trim());
            }
            catch (IOException e) {
                throw new FlumeException(String.format("Could not read password file %s", passwordFile), (Throwable)e);
            }
        }
        String converterClassName = context.getString("converter.type", "DEFAULT").trim();
        if ("DEFAULT".equalsIgnoreCase(converterClassName)) {
            converterClassName = DefaultJMSMessageConverter.Builder.class.getName();
        }
        Context converterContext = new Context((Map)context.getSubProperties("converter."));
        try {
            Class<?> clazz = Class.forName(converterClassName);
            boolean isBuilder = JMSMessageConverter.Builder.class.isAssignableFrom(clazz);
            if (isBuilder) {
                JMSMessageConverter.Builder builder = (JMSMessageConverter.Builder)clazz.newInstance();
                this.converter = builder.build(converterContext);
            } else {
                Preconditions.checkState((boolean)JMSMessageConverter.class.isAssignableFrom(clazz), (Object)String.format("Class %s is not a subclass of JMSMessageConverter", clazz.getName()));
                this.converter = (JMSMessageConverter)clazz.newInstance();
                boolean configured = Configurables.configure((Object)this.converter, (Context)converterContext);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Attempted configuration of %s, result = %s", converterClassName, String.valueOf(configured)));
                }
            }
        }
        catch (Exception e) {
            throw new FlumeException(String.format("Unable to create instance of converter %s", converterClassName), (Throwable)e);
        }
        String connectionFactoryName = context.getString("connectionFactory", "ConnectionFactory").trim();
        this.assertNotEmpty(this.initialContextFactoryName, String.format("Initial Context Factory is empty. This is specified by %s", "initialContextFactory"));
        this.assertNotEmpty(this.providerUrl, String.format("Provider URL is empty. This is specified by %s", "providerURL"));
        this.assertNotEmpty(this.destinationName, String.format("Destination Name is empty. This is specified by %s", "destinationName"));
        this.assertNotEmpty(destinationTypeName, String.format("Destination Type is empty. This is specified by %s", "destinationType"));
        try {
            this.destinationType = JMSDestinationType.valueOf(destinationTypeName);
        }
        catch (IllegalArgumentException e) {
            throw new FlumeException(String.format("Destination type '%s' is invalid.", destinationTypeName), (Throwable)e);
        }
        try {
            this.destinationLocator = JMSDestinationLocator.valueOf(destinationLocatorName);
        }
        catch (IllegalArgumentException e) {
            throw new FlumeException(String.format("Destination locator '%s' is invalid.", destinationLocatorName), (Throwable)e);
        }
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be greater than 0");
        try {
            Properties contextProperties = new Properties();
            contextProperties.setProperty("java.naming.factory.initial", this.initialContextFactoryName);
            contextProperties.setProperty("java.naming.provider.url", this.providerUrl);
            if (this.userName.isPresent()) {
                contextProperties.setProperty("java.naming.security.principal", (String)this.userName.get());
            }
            if (this.password.isPresent()) {
                contextProperties.setProperty("java.naming.security.credentials", (String)this.password.get());
            }
            this.initialContext = this.initialContextFactory.create(contextProperties);
        }
        catch (NamingException e) {
            throw new FlumeException(String.format("Could not create initial context %s provider %s", this.initialContextFactoryName, this.providerUrl), (Throwable)e);
        }
        try {
            this.connectionFactory = (ConnectionFactory)this.initialContext.lookup(connectionFactoryName);
        }
        catch (NamingException e) {
            throw new FlumeException("Could not lookup ConnectionFactory", (Throwable)e);
        }
    }

    private void assertNotEmpty(String arg, String msg) {
        Preconditions.checkArgument((!arg.isEmpty() ? 1 : 0) != 0, (Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized PollableSource.Status doProcess() throws EventDeliveryException {
        boolean error = true;
        try {
            List<Event> events;
            int size;
            if (this.consumer == null) {
                this.consumer = this.createConsumer();
            }
            if ((size = (events = this.consumer.take()).size()) == 0) {
                error = false;
                PollableSource.Status status = PollableSource.Status.BACKOFF;
                return status;
            }
            this.sourceCounter.incrementAppendBatchReceivedCount();
            this.sourceCounter.addToEventReceivedCount((long)size);
            this.getChannelProcessor().processEventBatch(events);
            error = false;
            this.sourceCounter.addToEventAcceptedCount((long)size);
            this.sourceCounter.incrementAppendBatchAcceptedCount();
            PollableSource.Status status = PollableSource.Status.READY;
            return status;
        }
        catch (ChannelException channelException) {
            logger.warn("Error appending event to channel. Channel might be full. Consider increasing the channel capacity or make sure the sinks perform faster.", (Throwable)channelException);
        }
        catch (JMSException jmsException) {
            logger.warn("JMSException consuming events", (Throwable)jmsException);
            if (++this.jmsExceptionCounter > this.errorThreshold && this.consumer != null) {
                logger.warn("Exceeded JMSException threshold, closing consumer");
                this.consumer.rollback();
                this.consumer.close();
                this.consumer = null;
            }
        }
        catch (Throwable throwable) {
            logger.error("Unexpected error processing events", throwable);
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        finally {
            if (error) {
                if (this.consumer != null) {
                    this.consumer.rollback();
                }
            } else if (this.consumer != null) {
                this.consumer.commit();
                this.jmsExceptionCounter = 0;
            }
        }
        return PollableSource.Status.BACKOFF;
    }

    protected synchronized void doStart() {
        try {
            this.consumer = this.createConsumer();
            this.jmsExceptionCounter = 0;
            this.sourceCounter.start();
        }
        catch (JMSException e) {
            throw new FlumeException("Unable to create consumer", (Throwable)e);
        }
    }

    protected synchronized void doStop() {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
        this.sourceCounter.stop();
    }

    private JMSMessageConsumer createConsumer() throws JMSException {
        logger.info("Creating new consumer for " + this.destinationName);
        JMSMessageConsumer consumer = this.consumerFactory.create(this.initialContext, this.connectionFactory, this.destinationName, this.destinationType, this.destinationLocator, this.messageSelector, this.batchSize, this.pollTimeout, this.converter, this.userName, this.password);
        this.jmsExceptionCounter = 0;
        return consumer;
    }
}

