/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.kafka;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(ChannelCallback.class);
    private int index;
    private long startTime;

    public ChannelCallback(int index, long startTime) {
        this.index = index;
        this.startTime = startTime;
    }

    public void onCompletion(RecordMetadata metadata, Exception exception) {
        if (exception != null) {
            log.trace("Error sending message to Kafka due to " + exception.getMessage());
        }
        if (log.isDebugEnabled()) {
            long batchElapsedTime = System.currentTimeMillis() - this.startTime;
            log.debug("Acked message_no " + this.index + ": " + metadata.topic() + "-" + metadata.partition() + "-" + metadata.offset() + "-" + batchElapsedTime);
        }
    }
}

