/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flume.ChannelException;
import org.apache.flume.ChannelFullException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.annotations.Recyclable;
import org.apache.flume.channel.BasicTransactionSemantics;
import org.apache.flume.channel.file.FileChannel;
import org.apache.flume.instrumentation.ChannelCounter;
import org.apache.flume.lifecycle.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recyclable
@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SpillableMemoryChannel
extends FileChannel {
    public static final String MEMORY_CAPACITY = "memoryCapacity";
    public static final String OVERFLOW_TIMEOUT = "overflowTimeout";
    public static final String OVERFLOW_DEACTIVATION_THRESHOLD = "overflowDeactivationThreshold";
    public static final String BYTE_CAPACITY_BUFFER_PERCENTAGE = "byteCapacityBufferPercentage";
    public static final String BYTE_CAPACITY = "byteCapacity";
    public static final String OVERFLOW_CAPACITY = "overflowCapacity";
    public static final String KEEP_ALIVE = "keep-alive";
    public static final String CAPACITY = "capacity";
    public static final String AVG_EVENT_SIZE = "avgEventSize";
    private static Logger LOGGER = LoggerFactory.getLogger(SpillableMemoryChannel.class);
    public static final int defaultMemoryCapacity = 10000;
    public static final int defaultOverflowCapacity = 100000000;
    public static final int defaultOverflowTimeout = 3;
    public static final int defaultOverflowDeactivationThreshold = 5;
    private static final int defaultAvgEventSize = 500;
    private static final Long defaultByteCapacity = (long)((double)Runtime.getRuntime().maxMemory() * 0.8);
    private static final int defaultByteCapacityBufferPercentage = 20;
    private volatile int byteCapacity;
    private volatile double avgEventSize = 500.0;
    private volatile int lastByteCapacity;
    private volatile int byteCapacityBufferPercentage;
    private Semaphore bytesRemaining;
    private final Object queueLock = new Object();
    @GuardedBy(value="queueLock")
    public ArrayDeque<Event> memQueue;
    private Semaphore memQueRemaining;
    private Semaphore totalStored;
    private int maxMemQueueSize = 0;
    private boolean overflowDisabled;
    private boolean overflowActivated = false;
    private int memoryCapacity = -1;
    private int overflowCapacity;
    private int overflowTimeout;
    private double overflowDeactivationThreshold = 0.0;
    @VisibleForTesting
    protected ChannelCounter channelCounter;
    public final DrainOrderQueue drainOrder = new DrainOrderQueue();

    protected int getTotalStored() {
        return this.totalStored.availablePermits();
    }

    public int getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public int getOverflowTimeout() {
        return this.overflowTimeout;
    }

    public int getMaxMemQueueSize() {
        return this.maxMemQueueSize;
    }

    protected Integer getOverflowCapacity() {
        return this.overflowCapacity;
    }

    protected boolean isOverflowDisabled() {
        return this.overflowDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueSize() {
        Object object = this.queueLock;
        synchronized (object) {
            return this.memQueue.size();
        }
    }

    public void configure(Context context) {
        Integer newMemoryCapacity;
        if (this.getLifecycleState() == LifecycleState.START || this.getLifecycleState() == LifecycleState.ERROR) {
            this.stop();
        }
        if (this.totalStored == null) {
            this.totalStored = new Semaphore(0);
        }
        if (this.channelCounter == null) {
            this.channelCounter = new ChannelCounter(this.getName());
        }
        try {
            newMemoryCapacity = context.getInteger(MEMORY_CAPACITY, Integer.valueOf(10000));
            if (newMemoryCapacity == null) {
                newMemoryCapacity = 10000;
            }
            if (newMemoryCapacity < 0) {
                throw new NumberFormatException("memoryCapacity must be >= 0");
            }
        }
        catch (NumberFormatException e) {
            newMemoryCapacity = 10000;
            LOGGER.warn("Invalid memoryCapacity specified, initializing " + this.getName() + " channel to default value of {}", (Object)10000);
        }
        try {
            this.resizePrimaryQueue(newMemoryCapacity);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            Integer newOverflowTimeout = context.getInteger(OVERFLOW_TIMEOUT, Integer.valueOf(3));
            this.overflowTimeout = newOverflowTimeout != null ? newOverflowTimeout : 3;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Incorrect value for " + this.getName() + "'s " + OVERFLOW_TIMEOUT + " setting. Using default value {}", (Object)3);
            this.overflowTimeout = 3;
        }
        try {
            Integer newThreshold = context.getInteger(OVERFLOW_DEACTIVATION_THRESHOLD);
            this.overflowDeactivationThreshold = newThreshold != null ? (double)newThreshold.intValue() / 100.0 : 0.05;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Incorrect value for " + this.getName() + "'s " + OVERFLOW_DEACTIVATION_THRESHOLD + ". Using default value {} %", (Object)5);
            this.overflowDeactivationThreshold = 0.05;
        }
        try {
            this.byteCapacityBufferPercentage = context.getInteger(BYTE_CAPACITY_BUFFER_PERCENTAGE, Integer.valueOf(20));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Error parsing byteCapacityBufferPercentage for " + this.getName() + ". Using default=" + 20 + ". " + e.getMessage());
            this.byteCapacityBufferPercentage = 20;
        }
        try {
            this.avgEventSize = context.getInteger(AVG_EVENT_SIZE, Integer.valueOf(500)).intValue();
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Error parsing avgEventSize for " + this.getName() + ". Using default = " + 500 + ". " + e.getMessage());
            this.avgEventSize = 500.0;
        }
        try {
            this.byteCapacity = (int)((double)context.getLong(BYTE_CAPACITY, defaultByteCapacity).longValue() * (1.0 - (double)this.byteCapacityBufferPercentage * 0.01) / this.avgEventSize);
            if (this.byteCapacity < 1) {
                this.byteCapacity = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Error parsing byteCapacity setting for " + this.getName() + ". Using default = " + defaultByteCapacity + ". " + e.getMessage());
            this.byteCapacity = (int)((double)defaultByteCapacity.longValue() * (1.0 - (double)this.byteCapacityBufferPercentage * 0.01) / this.avgEventSize);
        }
        if (this.bytesRemaining == null) {
            this.bytesRemaining = new Semaphore(this.byteCapacity);
            this.lastByteCapacity = this.byteCapacity;
        } else if (this.byteCapacity > this.lastByteCapacity) {
            this.bytesRemaining.release(this.byteCapacity - this.lastByteCapacity);
            this.lastByteCapacity = this.byteCapacity;
        } else {
            try {
                if (!this.bytesRemaining.tryAcquire(this.lastByteCapacity - this.byteCapacity, this.overflowTimeout, TimeUnit.SECONDS)) {
                    LOGGER.warn("Couldn't acquire permits to downsize the byte capacity, resizing has been aborted");
                } else {
                    this.lastByteCapacity = this.byteCapacity;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            this.overflowCapacity = context.getInteger(OVERFLOW_CAPACITY, Integer.valueOf(100000000));
            if (this.memoryCapacity < 1 && this.overflowCapacity < 1) {
                LOGGER.warn("For channel " + this.getName() + OVERFLOW_CAPACITY + " cannot be set to 0 if " + MEMORY_CAPACITY + " is also 0. " + "Using default value " + OVERFLOW_CAPACITY + " = " + 100000000);
                this.overflowCapacity = 100000000;
            }
            boolean bl = this.overflowDisabled = this.overflowCapacity < 1;
            if (this.overflowDisabled) {
                this.overflowActivated = false;
            }
        }
        catch (NumberFormatException e) {
            this.overflowCapacity = 100000000;
        }
        context.put(KEEP_ALIVE, "0");
        context.put(CAPACITY, Integer.toString(this.overflowCapacity));
        super.configure(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizePrimaryQueue(int newMemoryCapacity) throws InterruptedException {
        if (this.memQueue != null && this.memoryCapacity == newMemoryCapacity) {
            return;
        }
        if (this.memoryCapacity > newMemoryCapacity) {
            int diff = this.memoryCapacity - newMemoryCapacity;
            if (!this.memQueRemaining.tryAcquire(diff, this.overflowTimeout, TimeUnit.SECONDS)) {
                LOGGER.warn("Memory buffer currently contains more events than the new size. Downsizing has been aborted.");
                return;
            }
            Object object = this.queueLock;
            synchronized (object) {
                ArrayDeque<Event> newQueue = new ArrayDeque<Event>(newMemoryCapacity);
                newQueue.addAll(this.memQueue);
                this.memQueue = newQueue;
                this.memoryCapacity = newMemoryCapacity;
            }
        }
        Object object = this.queueLock;
        synchronized (object) {
            ArrayDeque<Event> newQueue = new ArrayDeque<Event>(newMemoryCapacity);
            if (this.memQueue != null) {
                newQueue.addAll(this.memQueue);
            }
            this.memQueue = newQueue;
            if (this.memQueRemaining == null) {
                this.memQueRemaining = new Semaphore(newMemoryCapacity);
            } else {
                int diff = newMemoryCapacity - this.memoryCapacity;
                this.memQueRemaining.release(diff);
            }
            this.memoryCapacity = newMemoryCapacity;
        }
    }

    public synchronized void start() {
        super.start();
        int overFlowCount = super.getDepth();
        if (this.drainOrder.isEmpty()) {
            this.drainOrder.putOverflow(overFlowCount);
            this.totalStored.release(overFlowCount);
        }
        int totalCount = overFlowCount + this.memQueue.size();
        this.channelCounter.setChannelCapacity((long)(this.memoryCapacity + this.getOverflowCapacity()));
        this.channelCounter.setChannelSize((long)totalCount);
    }

    public synchronized void stop() {
        if (this.getLifecycleState() == LifecycleState.STOP) {
            return;
        }
        this.channelCounter.setChannelSize((long)this.memQueue.size() + this.drainOrder.overflowCounter);
        this.channelCounter.stop();
        super.stop();
    }

    protected BasicTransactionSemantics createTransaction() {
        return new SpillableMemoryTransaction(this.channelCounter);
    }

    private BasicTransactionSemantics getOverflowTx() {
        return super.createTransaction();
    }

    private long estimateEventSize(Event event) {
        byte[] body = event.getBody();
        if (body != null && body.length != 0) {
            return body.length;
        }
        return 1L;
    }

    private class SpillableMemoryTransaction
    extends BasicTransactionSemantics {
        BasicTransactionSemantics overflowTakeTx = null;
        BasicTransactionSemantics overflowPutTx = null;
        boolean useOverflow = false;
        boolean putCalled = false;
        boolean takeCalled = false;
        int largestTakeTxSize = 5000;
        int largestPutTxSize = 5000;
        Integer overflowPutCount = 0;
        private int putListByteCount = 0;
        private int takeListByteCount = 0;
        private int takeCount = 0;
        ArrayDeque<Event> takeList = new ArrayDeque(this.largestTakeTxSize);
        ArrayDeque<Event> putList = new ArrayDeque(this.largestPutTxSize);
        private final ChannelCounter channelCounter;

        public SpillableMemoryTransaction(ChannelCounter counter) {
            this.channelCounter = counter;
        }

        public void begin() {
            super.begin();
        }

        public void close() {
            if (this.overflowTakeTx != null) {
                this.overflowTakeTx.close();
            }
            if (this.overflowPutTx != null) {
                this.overflowPutTx.close();
            }
            super.close();
        }

        protected void doPut(Event event) throws InterruptedException {
            this.channelCounter.incrementEventPutAttemptCount();
            this.putCalled = true;
            int eventByteSize = (int)Math.ceil((double)SpillableMemoryChannel.this.estimateEventSize(event) / SpillableMemoryChannel.this.avgEventSize);
            if (!this.putList.offer(event)) {
                throw new ChannelFullException("Put queue in " + SpillableMemoryChannel.this.getName() + " channel's Transaction having capacity " + this.putList.size() + " full, consider reducing batch size of sources");
            }
            this.putListByteCount += eventByteSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Event doTake() throws InterruptedException {
            block16: {
                this.channelCounter.incrementEventTakeAttemptCount();
                if (!SpillableMemoryChannel.access$300(SpillableMemoryChannel.this).tryAcquire(SpillableMemoryChannel.access$200(SpillableMemoryChannel.this), TimeUnit.SECONDS)) {
                    SpillableMemoryChannel.access$400().debug("Take is backing off as channel is empty.");
                    return null;
                }
                takeSuceeded = false;
                var3_2 = SpillableMemoryChannel.access$500(SpillableMemoryChannel.this);
                synchronized (var3_2) {
                    drainOrderTop = SpillableMemoryChannel.this.drainOrder.front();
                    if (!this.takeCalled) {
                        this.takeCalled = true;
                        if (drainOrderTop < 0) {
                            this.useOverflow = true;
                            this.overflowTakeTx = SpillableMemoryChannel.access$600(SpillableMemoryChannel.this);
                            this.overflowTakeTx.begin();
                        }
                    }
                    if (!this.useOverflow) break block15;
                    if (drainOrderTop > 0) {
                        SpillableMemoryChannel.access$400().debug("Take is switching to primary");
                        var5_6 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 14] lbl21 : MonitorExitStatement: MONITOREXIT : var3_2
                        if (takeSuceeded != false) return var5_6;
                        SpillableMemoryChannel.access$300(SpillableMemoryChannel.this).release();
                        return var5_6;
                    }
                }
                {
                    block15: {
                        event = this.overflowTakeTx.take();
                        ++this.takeCount;
                        SpillableMemoryChannel.this.drainOrder.takeOverflow(1);
                        break block16;
                    }
                    if (drainOrderTop < 0) {
                        SpillableMemoryChannel.access$400().debug("Take is switching to overflow");
                        var5_7 = null;
                        // MONITOREXIT @DISABLED, blocks:[5, 10] lbl35 : MonitorExitStatement: MONITOREXIT : var3_2
                        if (takeSuceeded != false) return var5_7;
                        SpillableMemoryChannel.access$300(SpillableMemoryChannel.this).release();
                        return var5_7;
                    }
                    ** try [egrp 3[TRYBLOCK] [6 : 221->328)] { 
lbl41:
                    // 1 sources

                    event = SpillableMemoryChannel.this.memQueue.poll();
                    ++this.takeCount;
                    SpillableMemoryChannel.this.drainOrder.takePrimary(1);
                    Preconditions.checkNotNull((Object)event, (Object)"Queue.poll returned NULL despite semaphore signalling existence of entry");
                }
            }
            eventByteSize = (int)Math.ceil((double)SpillableMemoryChannel.access$000(SpillableMemoryChannel.this, event) / SpillableMemoryChannel.access$100(SpillableMemoryChannel.this));
            if (!this.useOverflow) {
                this.takeList.offer(event);
            }
            this.takeListByteCount += eventByteSize;
            takeSuceeded = true;
            return event;
lbl-1000:
            // 1 sources

            {
                finally {
                    if (!takeSuceeded) {
                        SpillableMemoryChannel.access$300(SpillableMemoryChannel.this).release();
                    }
                }
            }
        }

        protected void doCommit() throws InterruptedException {
            if (this.putCalled) {
                this.putCommit();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Put Committed. Drain Order Queue state : " + SpillableMemoryChannel.this.drainOrder.dump());
                }
            } else if (this.takeCalled) {
                this.takeCommit();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Take Committed. Drain Order Queue state : " + SpillableMemoryChannel.this.drainOrder.dump());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void takeCommit() {
            if (this.takeCount > this.largestTakeTxSize) {
                this.largestTakeTxSize = this.takeCount;
            }
            Object object = SpillableMemoryChannel.this.queueLock;
            synchronized (object) {
                double memoryPercentFree;
                if (this.overflowTakeTx != null) {
                    this.overflowTakeTx.commit();
                }
                double d = memoryPercentFree = SpillableMemoryChannel.this.memoryCapacity == 0 ? 0.0 : (double)(SpillableMemoryChannel.this.memoryCapacity - SpillableMemoryChannel.this.memQueue.size() + this.takeCount) / (double)SpillableMemoryChannel.this.memoryCapacity;
                if (SpillableMemoryChannel.this.overflowActivated && memoryPercentFree >= SpillableMemoryChannel.this.overflowDeactivationThreshold) {
                    SpillableMemoryChannel.this.overflowActivated = false;
                    LOGGER.info("Overflow Deactivated");
                }
                this.channelCounter.setChannelSize((long)SpillableMemoryChannel.this.getTotalStored());
            }
            if (!this.useOverflow) {
                SpillableMemoryChannel.this.memQueRemaining.release(this.takeCount);
                SpillableMemoryChannel.this.bytesRemaining.release(this.takeListByteCount);
            }
            this.channelCounter.addToEventTakeSuccessCount((long)this.takeCount);
        }

        private void putCommit() throws InterruptedException {
            int timeout;
            int n = timeout = SpillableMemoryChannel.this.overflowActivated ? 0 : SpillableMemoryChannel.this.overflowTimeout;
            if (SpillableMemoryChannel.this.memoryCapacity != 0) {
                if (!SpillableMemoryChannel.this.memQueRemaining.tryAcquire(this.putList.size(), timeout, TimeUnit.SECONDS)) {
                    if (SpillableMemoryChannel.this.overflowDisabled) {
                        throw new ChannelFullException("Spillable Memory Channel's memory capacity has been reached and overflow is disabled. Consider increasing memoryCapacity.");
                    }
                    SpillableMemoryChannel.this.overflowActivated = true;
                    this.useOverflow = true;
                } else if (!SpillableMemoryChannel.this.bytesRemaining.tryAcquire(this.putListByteCount, SpillableMemoryChannel.this.overflowTimeout, TimeUnit.SECONDS)) {
                    SpillableMemoryChannel.this.memQueRemaining.release(this.putList.size());
                    if (SpillableMemoryChannel.this.overflowDisabled) {
                        throw new ChannelFullException("Spillable Memory Channel's memory capacity has been reached.  " + SpillableMemoryChannel.this.bytesRemaining.availablePermits() * (int)SpillableMemoryChannel.this.avgEventSize + " bytes are free and overflow is disabled. Consider " + "increasing byteCapacity or capacity.");
                    }
                    SpillableMemoryChannel.this.overflowActivated = true;
                    this.useOverflow = true;
                }
            } else {
                this.useOverflow = true;
            }
            if (this.putList.size() > this.largestPutTxSize) {
                this.largestPutTxSize = this.putList.size();
            }
            if (this.useOverflow) {
                this.commitPutsToOverflow();
            } else {
                this.commitPutsToPrimary();
            }
        }

        private void commitPutsToOverflow() throws InterruptedException {
            this.overflowPutTx = SpillableMemoryChannel.this.getOverflowTx();
            this.overflowPutTx.begin();
            for (Event event : this.putList) {
                this.overflowPutTx.put(event);
            }
            this.commitPutsToOverflow_core((Transaction)this.overflowPutTx);
            SpillableMemoryChannel.this.totalStored.release(this.putList.size());
            this.overflowPutCount = this.overflowPutCount + this.putList.size();
            this.channelCounter.addToEventPutSuccessCount((long)this.putList.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitPutsToOverflow_core(Transaction overflowPutTx) throws InterruptedException {
            for (int i = 0; i < 2; ++i) {
                try {
                    Object object = SpillableMemoryChannel.this.queueLock;
                    synchronized (object) {
                        overflowPutTx.commit();
                        SpillableMemoryChannel.this.drainOrder.putOverflow(this.putList.size());
                        this.channelCounter.setChannelSize((long)SpillableMemoryChannel.this.memQueue.size() + SpillableMemoryChannel.this.drainOrder.overflowCounter);
                        break;
                    }
                }
                catch (ChannelFullException e) {
                    if (i != 0) {
                        throw e;
                    }
                    Thread.sleep(SpillableMemoryChannel.this.overflowTimeout * 1000);
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitPutsToPrimary() {
            Object object = SpillableMemoryChannel.this.queueLock;
            synchronized (object) {
                for (Event e : this.putList) {
                    if (SpillableMemoryChannel.this.memQueue.offer(e)) continue;
                    throw new ChannelException("Unable to insert event into memory queue in spite of spare capacity, this is very unexpected");
                }
                SpillableMemoryChannel.this.drainOrder.putPrimary(this.putList.size());
                SpillableMemoryChannel.this.maxMemQueueSize = SpillableMemoryChannel.this.memQueue.size() > SpillableMemoryChannel.this.maxMemQueueSize ? SpillableMemoryChannel.this.memQueue.size() : SpillableMemoryChannel.this.maxMemQueueSize;
                this.channelCounter.setChannelSize((long)SpillableMemoryChannel.this.memQueue.size() + SpillableMemoryChannel.this.drainOrder.overflowCounter);
            }
            SpillableMemoryChannel.this.totalStored.release(this.putList.size());
            this.channelCounter.addToEventPutSuccessCount((long)this.putList.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRollback() {
            LOGGER.debug("Rollback() of " + (this.takeCalled ? " Take Tx" : (this.putCalled ? " Put Tx" : "Empty Tx")));
            if (this.putCalled) {
                if (this.overflowPutTx != null) {
                    this.overflowPutTx.rollback();
                }
                if (!this.useOverflow) {
                    SpillableMemoryChannel.this.bytesRemaining.release(this.putListByteCount);
                    this.putList.clear();
                }
                this.putListByteCount = 0;
            } else if (this.takeCalled) {
                Object object = SpillableMemoryChannel.this.queueLock;
                synchronized (object) {
                    if (this.overflowTakeTx != null) {
                        this.overflowTakeTx.rollback();
                    }
                    if (this.useOverflow) {
                        SpillableMemoryChannel.this.drainOrder.putFirstOverflow(this.takeCount);
                    } else {
                        int remainingCapacity = SpillableMemoryChannel.this.memoryCapacity - SpillableMemoryChannel.this.memQueue.size();
                        Preconditions.checkState((remainingCapacity >= this.takeCount ? 1 : 0) != 0, (Object)"Not enough space in memory queue to rollback takes. This should never happen, please report");
                        while (!this.takeList.isEmpty()) {
                            SpillableMemoryChannel.this.memQueue.addFirst(this.takeList.removeLast());
                        }
                        SpillableMemoryChannel.this.drainOrder.putFirstPrimary(this.takeCount);
                    }
                }
                SpillableMemoryChannel.this.totalStored.release(this.takeCount);
            } else {
                this.overflowTakeTx.rollback();
            }
            this.channelCounter.setChannelSize((long)SpillableMemoryChannel.this.memQueue.size() + SpillableMemoryChannel.this.drainOrder.overflowCounter);
        }
    }

    public static class DrainOrderQueue {
        public ArrayDeque<MutableInteger> queue = new ArrayDeque(1000);
        public int totalPuts = 0;
        private long overflowCounter = 0L;

        public String dump() {
            StringBuilder sb = new StringBuilder();
            sb.append("  [ ");
            for (MutableInteger i : this.queue) {
                sb.append(i.intValue());
                sb.append(" ");
            }
            sb.append("]");
            return sb.toString();
        }

        public void putPrimary(Integer eventCount) {
            this.totalPuts += eventCount.intValue();
            if (this.queue.peekLast() == null || this.queue.getLast().intValue() < 0) {
                this.queue.addLast(new MutableInteger(eventCount));
            } else {
                this.queue.getLast().add(eventCount);
            }
        }

        public void putFirstPrimary(Integer eventCount) {
            if (this.queue.peekFirst() == null || this.queue.getFirst().intValue() < 0) {
                this.queue.addFirst(new MutableInteger(eventCount));
            } else {
                this.queue.getFirst().add(eventCount);
            }
        }

        public void putOverflow(Integer eventCount) {
            this.totalPuts += eventCount.intValue();
            if (this.queue.peekLast() == null || this.queue.getLast().intValue() > 0) {
                this.queue.addLast(new MutableInteger(-eventCount.intValue()));
            } else {
                this.queue.getLast().add(-eventCount.intValue());
            }
            this.overflowCounter += (long)eventCount.intValue();
        }

        public void putFirstOverflow(Integer eventCount) {
            if (this.queue.peekFirst() == null || this.queue.getFirst().intValue() > 0) {
                this.queue.addFirst(new MutableInteger(-eventCount.intValue()));
            } else {
                this.queue.getFirst().add(-eventCount.intValue());
            }
            this.overflowCounter += (long)eventCount.intValue();
        }

        public int front() {
            return this.queue.getFirst().intValue();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void takePrimary(int takeCount) {
            MutableInteger headValue = this.queue.getFirst();
            if (headValue.intValue() < takeCount) {
                throw new IllegalStateException("Cannot take " + takeCount + " from " + headValue.intValue() + " in DrainOrder Queue");
            }
            headValue.add(-takeCount);
            if (headValue.intValue() == 0) {
                this.queue.removeFirst();
            }
        }

        public void takeOverflow(int takeCount) {
            MutableInteger headValue = this.queue.getFirst();
            if (headValue.intValue() > -takeCount) {
                throw new IllegalStateException("Cannot take " + takeCount + " from " + headValue.intValue() + " in DrainOrder Queue head ");
            }
            headValue.add(takeCount);
            if (headValue.intValue() == 0) {
                this.queue.removeFirst();
            }
            this.overflowCounter -= (long)takeCount;
        }
    }

    private static class MutableInteger {
        private int value;

        public MutableInteger(int val) {
            this.value = val;
        }

        public void add(int amount) {
            this.value += amount;
        }

        public int intValue() {
            return this.value;
        }
    }
}

