/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flume.channel.file.Commit;
import org.apache.flume.channel.file.EventQueueBackingStore;
import org.apache.flume.channel.file.EventQueueBackingStoreFactory;
import org.apache.flume.channel.file.FlumeEventPointer;
import org.apache.flume.channel.file.FlumeEventQueue;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogFileFactory;
import org.apache.flume.channel.file.LogRecord;
import org.apache.flume.channel.file.LogUtils;
import org.apache.flume.channel.file.Take;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.TransactionIDOracle;
import org.apache.flume.channel.file.WriteOrderOracle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointRebuilder {
    private final List<File> logFiles;
    private final FlumeEventQueue queue;
    private final Set<ComparableFlumeEventPointer> committedPuts = Sets.newHashSet();
    private final Set<ComparableFlumeEventPointer> pendingTakes = Sets.newHashSet();
    private final SetMultimap<Long, ComparableFlumeEventPointer> uncommittedPuts = HashMultimap.create();
    private final SetMultimap<Long, ComparableFlumeEventPointer> uncommittedTakes = HashMultimap.create();
    private final boolean fsyncPerTransaction;
    private static Logger LOG = LoggerFactory.getLogger(CheckpointRebuilder.class);

    public CheckpointRebuilder(List<File> logFiles, FlumeEventQueue queue, boolean fsyncPerTransaction) throws IOException {
        this.logFiles = logFiles;
        this.queue = queue;
        this.fsyncPerTransaction = fsyncPerTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rebuild() throws IOException, Exception {
        LOG.info("Attempting to fast replay the log files.");
        ArrayList logReaders = Lists.newArrayList();
        for (File logFile : this.logFiles) {
            try {
                logReaders.add(LogFileFactory.getSequentialReader(logFile, null, this.fsyncPerTransaction));
            }
            catch (EOFException e) {
                LOG.warn("Ignoring " + logFile + " due to EOF", (Throwable)e);
            }
        }
        long transactionIDSeed = 0L;
        long writeOrderIDSeed = 0L;
        try {
            for (LogFile.SequentialReader log : logReaders) {
                LogRecord entry;
                int fileID = log.getLogFileID();
                while ((entry = log.next()) != null) {
                    int offset = entry.getOffset();
                    TransactionEventRecord record = entry.getEvent();
                    long trans = record.getTransactionID();
                    long writeOrderID = record.getLogWriteOrderID();
                    transactionIDSeed = Math.max(trans, transactionIDSeed);
                    writeOrderIDSeed = Math.max(writeOrderID, writeOrderIDSeed);
                    if (record.getRecordType() == TransactionEventRecord.Type.PUT.get()) {
                        this.uncommittedPuts.put((Object)record.getTransactionID(), (Object)new ComparableFlumeEventPointer(new FlumeEventPointer(fileID, offset), record.getLogWriteOrderID()));
                        continue;
                    }
                    if (record.getRecordType() == TransactionEventRecord.Type.TAKE.get()) {
                        Take take = (Take)record;
                        this.uncommittedTakes.put((Object)record.getTransactionID(), (Object)new ComparableFlumeEventPointer(new FlumeEventPointer(take.getFileID(), take.getOffset()), record.getLogWriteOrderID()));
                        continue;
                    }
                    if (record.getRecordType() == TransactionEventRecord.Type.COMMIT.get()) {
                        Commit commit = (Commit)record;
                        if (commit.getType() == TransactionEventRecord.Type.PUT.get()) {
                            Set puts = this.uncommittedPuts.get((Object)record.getTransactionID());
                            if (puts == null) continue;
                            for (ComparableFlumeEventPointer put : puts) {
                                if (this.pendingTakes.remove(put)) continue;
                                this.committedPuts.add(put);
                            }
                            continue;
                        }
                        Set takes = this.uncommittedTakes.get((Object)record.getTransactionID());
                        if (takes == null) continue;
                        for (ComparableFlumeEventPointer take : takes) {
                            if (this.committedPuts.remove(take)) continue;
                            this.pendingTakes.add(take);
                        }
                        continue;
                    }
                    if (record.getRecordType() != TransactionEventRecord.Type.ROLLBACK.get()) continue;
                    if (this.uncommittedPuts.containsKey((Object)record.getTransactionID())) {
                        this.uncommittedPuts.removeAll((Object)record.getTransactionID());
                        continue;
                    }
                    this.uncommittedTakes.removeAll((Object)record.getTransactionID());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error while generating checkpoint using fast generation logic", (Throwable)e);
            boolean reader = false;
            return reader;
        }
        finally {
            TransactionIDOracle.setSeed(transactionIDSeed);
            WriteOrderOracle.setSeed(writeOrderIDSeed);
            for (LogFile.SequentialReader reader : logReaders) {
                reader.close();
            }
        }
        TreeSet sortedPuts = Sets.newTreeSet(this.committedPuts);
        int count = 0;
        for (ComparableFlumeEventPointer put : sortedPuts) {
            this.queue.addTail(put.pointer);
            ++count;
        }
        LOG.info("Replayed {} events using fast replay logic.", (Object)count);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCheckpoint() throws IOException {
        block8: {
            long checkpointLogOrderID = 0L;
            ArrayList metaDataWriters = Lists.newArrayList();
            for (File logFile : this.logFiles) {
                String name = logFile.getName();
                metaDataWriters.add(LogFileFactory.getMetaDataWriter(logFile, Integer.parseInt(name.substring(name.lastIndexOf(45) + 1))));
            }
            try {
                if (!this.queue.checkpoint(true)) break block8;
                checkpointLogOrderID = this.queue.getLogWriteOrderID();
                for (LogFile.MetaDataWriter metaDataWriter : metaDataWriters) {
                    metaDataWriter.markCheckpoint(checkpointLogOrderID);
                }
            }
            catch (Exception e) {
                LOG.warn("Error while generating checkpoint using fast generation logic", (Throwable)e);
            }
            finally {
                for (LogFile.MetaDataWriter metaDataWriter : metaDataWriters) {
                    metaDataWriter.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        Option opt = new Option("c", true, "checkpoint directory");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("l", true, "comma-separated list of log directories");
        opt.setRequired(true);
        options.addOption(opt);
        options.addOption(opt);
        opt = new Option("t", true, "capacity of the channel");
        opt.setRequired(true);
        options.addOption(opt);
        GnuParser parser = new GnuParser();
        CommandLine cli = parser.parse(options, args);
        File checkpointDir = new File(cli.getOptionValue("c"));
        String[] logDirs = cli.getOptionValue("l").split(",");
        ArrayList logFiles = Lists.newArrayList();
        for (String logDir : logDirs) {
            logFiles.addAll(LogUtils.getLogs(new File(logDir)));
        }
        int capacity = Integer.parseInt(cli.getOptionValue("t"));
        File checkpointFile = new File(checkpointDir, "checkpoint");
        if (checkpointFile.exists()) {
            LOG.error("Cannot execute fast replay", (Throwable)new IllegalStateException("Checkpoint exists" + checkpointFile));
        } else {
            EventQueueBackingStore backingStore = EventQueueBackingStoreFactory.get(checkpointFile, capacity, "channel");
            FlumeEventQueue queue = new FlumeEventQueue(backingStore, new File(checkpointDir, "inflighttakes"), new File(checkpointDir, "inflightputs"), new File(checkpointDir, "queueset"));
            CheckpointRebuilder rebuilder = new CheckpointRebuilder(logFiles, queue, true);
            if (rebuilder.rebuild()) {
                rebuilder.writeCheckpoint();
            } else {
                LOG.error("Could not rebuild the checkpoint due to errors.");
            }
        }
    }

    private final class ComparableFlumeEventPointer
    implements Comparable<ComparableFlumeEventPointer> {
        private final FlumeEventPointer pointer;
        private final long orderID;

        public ComparableFlumeEventPointer(FlumeEventPointer pointer, long orderID) {
            Preconditions.checkNotNull((Object)pointer, (Object)"FlumeEventPointer cannot benull while creating a ComparableFlumeEventPointer");
            this.pointer = pointer;
            this.orderID = orderID;
        }

        @Override
        public int compareTo(ComparableFlumeEventPointer o) {
            if (this.orderID < o.orderID) {
                return -1;
            }
            return 1;
        }

        public int hashCode() {
            return this.pointer.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return this.pointer.equals(((ComparableFlumeEventPointer)o).pointer);
        }
    }
}

