/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kite.policy;

import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.sink.kite.policy.FailurePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryPolicy
implements FailurePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RetryPolicy.class);

    private RetryPolicy() {
    }

    @Override
    public void handle(Event event, Throwable cause) throws EventDeliveryException {
        LOG.error("Event delivery failed: " + cause.getLocalizedMessage());
        LOG.debug("Exception follows.", cause);
        throw new EventDeliveryException(cause);
    }

    @Override
    public void sync() throws EventDeliveryException {
    }

    @Override
    public void close() throws EventDeliveryException {
    }

    public static class Builder
    implements FailurePolicy.Builder {
        @Override
        public FailurePolicy build(Context config) {
            return new RetryPolicy();
        }
    }
}

