/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kite.parser;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.sink.kite.NonRecoverableEventException;
import org.apache.flume.sink.kite.parser.EntityParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AvroParser
implements EntityParser<GenericRecord> {
    static Configuration conf = new Configuration();
    private static final LoadingCache<String, Schema> schemasFromLiteral = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Schema>(){

        public Schema load(String literal) {
            Preconditions.checkNotNull((Object)literal, (Object)"Schema literal cannot be null without a Schema URL");
            return new Schema.Parser().parse(literal);
        }
    });
    private static final LoadingCache<String, Schema> schemasFromURL = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Schema>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Schema load(String url) throws IOException {
            Schema.Parser parser = new Schema.Parser();
            InputStream is = null;
            try {
                FileSystem fs = FileSystem.get((URI)URI.create(url), (Configuration)conf);
                is = url.toLowerCase(Locale.ENGLISH).startsWith("hdfs:/") ? fs.open(new Path(url)) : new URL(url).openStream();
                Schema schema = parser.parse(is);
                return schema;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    });
    private final Schema datasetSchema;
    private final LoadingCache<Schema, DatumReader<GenericRecord>> readers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Schema, DatumReader<GenericRecord>>(){

        public DatumReader<GenericRecord> load(Schema schema) {
            return new GenericDatumReader(schema, AvroParser.this.datasetSchema);
        }
    });
    private BinaryDecoder decoder = null;

    private AvroParser(Schema datasetSchema) {
        this.datasetSchema = datasetSchema;
    }

    @Override
    public GenericRecord parse(Event event, GenericRecord reuse) throws EventDeliveryException, NonRecoverableEventException {
        this.decoder = DecoderFactory.get().binaryDecoder(event.getBody(), this.decoder);
        try {
            DatumReader reader = (DatumReader)this.readers.getUnchecked((Object)AvroParser.schema(event));
            return (GenericRecord)reader.read((Object)reuse, (Decoder)this.decoder);
        }
        catch (IOException ex) {
            throw new NonRecoverableEventException("Cannot deserialize event", ex);
        }
        catch (RuntimeException ex) {
            throw new NonRecoverableEventException("Cannot deserialize event", ex);
        }
    }

    private static Schema schema(Event event) throws EventDeliveryException, NonRecoverableEventException {
        Map headers = event.getHeaders();
        String schemaURL = (String)headers.get("flume.avro.schema.url");
        try {
            if (schemaURL != null) {
                return (Schema)schemasFromURL.get((Object)schemaURL);
            }
            String schemaLiteral = (String)headers.get("flume.avro.schema.literal");
            if (schemaLiteral == null) {
                throw new NonRecoverableEventException("No schema in event headers. Headers must include either flume.avro.schema.url or flume.avro.schema.literal");
            }
            return (Schema)schemasFromLiteral.get((Object)schemaLiteral);
        }
        catch (ExecutionException ex) {
            throw new EventDeliveryException("Cannot get schema", ex.getCause());
        }
        catch (UncheckedExecutionException ex) {
            throw new NonRecoverableEventException("Cannot parse schema", ex.getCause());
        }
    }

    public static class Builder
    implements EntityParser.Builder<GenericRecord> {
        @Override
        public EntityParser<GenericRecord> build(Schema datasetSchema, Context config) {
            return new AvroParser(datasetSchema);
        }
    }
}

