/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.text.NumberFormat;
import org.apache.avro.Schema;
import org.kitesdk.data.spi.SchemaUtil;

public class Conversions {
    public static <T> T convert(Object obj, Class<T> returnType) {
        if (obj == null) {
            return null;
        }
        if (returnType == Object.class) {
            return returnType.cast(obj);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(Conversions.makeLong(obj));
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            return returnType.cast(Conversions.makeInteger(obj));
        }
        if (returnType.isAssignableFrom(String.class)) {
            return returnType.cast(Conversions.makeString(obj));
        }
        if (returnType.isAssignableFrom(Double.class)) {
            return returnType.cast(Conversions.makeDouble(obj));
        }
        if (returnType.isAssignableFrom(Float.class)) {
            return returnType.cast(Conversions.makeFloat(obj));
        }
        throw new ClassCastException("Cannot convert to unknown return type:" + returnType.getName());
    }

    public static Object convert(Object obj, Schema schema) {
        Class<?> returnType = SchemaUtil.getClassForType(schema.getType());
        if (returnType != null) {
            return Conversions.convert(obj, returnType);
        }
        switch (schema.getType()) {
            case UNION: {
                for (Schema possibleSchema : schema.getTypes()) {
                    try {
                        return Conversions.convert(obj, SchemaUtil.getClassForType(possibleSchema.getType()));
                    }
                    catch (ClassCastException e) {
                    }
                }
                break;
            }
        }
        throw new ClassCastException("Cannot convert using schema: " + schema.toString(true));
    }

    public static Long makeLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new RuntimeException("Cannot coerce \"" + value + "\" to Long");
    }

    public static Integer makeInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new RuntimeException("Cannot coerce \"" + value + "\" to Integer");
    }

    public static Double makeDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        throw new RuntimeException("Cannot coerce \"" + value + "\" to Double");
    }

    public static Float makeFloat(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf((String)value);
        }
        throw new RuntimeException("Cannot coerce \"" + value + "\" to Double");
    }

    public static String makeString(Object value) {
        return value.toString();
    }

    public static String makeString(Object value, Integer width) {
        if (width != null && value instanceof Number) {
            NumberFormat format = NumberFormat.getInstance();
            format.setMinimumIntegerDigits(width);
            format.setGroupingUsed(false);
            return format.format(value);
        }
        return Conversions.makeString(value);
    }
}

