/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;

public class UUIDInterceptor
implements Interceptor {
    private String headerName;
    private boolean preserveExisting;
    private String prefix;
    public static final String HEADER_NAME = "headerName";
    public static final String PRESERVE_EXISTING_NAME = "preserveExisting";
    public static final String PREFIX_NAME = "prefix";

    protected UUIDInterceptor(Context context) {
        this.headerName = context.getString(HEADER_NAME, "id");
        this.preserveExisting = context.getBoolean(PRESERVE_EXISTING_NAME, Boolean.valueOf(true));
        this.prefix = context.getString(PREFIX_NAME, "");
    }

    public void initialize() {
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected String generateUUID() {
        return this.getPrefix() + UUID.randomUUID().toString();
    }

    protected boolean isMatch(Event event) {
        return true;
    }

    public Event intercept(Event event) {
        Map headers = event.getHeaders();
        if (!(this.preserveExisting && headers.containsKey(this.headerName) || !this.isMatch(event))) {
            headers.put(this.headerName, this.generateUUID());
        }
        return event;
    }

    public List<Event> intercept(List<Event> events) {
        ArrayList<Event> results = new ArrayList<Event>(events.size());
        for (Event event : events) {
            if ((event = this.intercept(event)) == null) continue;
            results.add(event);
        }
        return results;
    }

    public void close() {
    }

    public static class Builder
    implements Interceptor.Builder {
        private Context context;

        public UUIDInterceptor build() {
            return new UUIDInterceptor(this.context);
        }

        public void configure(Context context) {
            this.context = context;
        }
    }
}

