/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.io.IOException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.Flushable;
import org.kitesdk.data.hbase.impl.EntityBatch;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.HBaseClientTemplate;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.spi.AbstractDatasetWriter;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.shaded.com.google.common.base.Preconditions;

public class BaseEntityBatch<E>
extends AbstractDatasetWriter<E>
implements EntityBatch<E>,
Flushable {
    private final HTableInterface table;
    private final EntityMapper<E> entityMapper;
    private final HBaseClientTemplate clientTemplate;
    private ReaderWriterState state;

    public BaseEntityBatch(HBaseClientTemplate clientTemplate, EntityMapper<E> entityMapper, HTablePool pool, String tableName, long writeBufferSize) {
        this.table = pool.getTable(tableName);
        this.table.setAutoFlush(false);
        this.clientTemplate = clientTemplate;
        this.entityMapper = entityMapper;
        this.state = ReaderWriterState.NEW;
        try {
            this.table.setWriteBufferSize(writeBufferSize);
        }
        catch (IOException e) {
            throw new DatasetIOException("Error flushing commits for table [" + this.table + "]", e);
        }
    }

    public BaseEntityBatch(HBaseClientTemplate clientTemplate, EntityMapper<E> entityMapper, HTablePool pool, String tableName) {
        this.table = pool.getTable(tableName);
        this.table.setAutoFlush(false);
        this.clientTemplate = clientTemplate;
        this.entityMapper = entityMapper;
        this.state = ReaderWriterState.NEW;
    }

    public void initialize() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.NEW), "Unable to open a writer from state:%s", this.state);
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public void put(E entity) {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to write to a writer in state:%s", this.state);
        PutAction putAction = this.entityMapper.mapFromEntity(entity);
        this.clientTemplate.put(putAction, this.table);
    }

    public void write(E entity) {
        this.put(entity);
    }

    @Override
    public void flush() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to flush a writer in state:%s", this.state);
        try {
            this.table.flushCommits();
        }
        catch (IOException e) {
            throw new DatasetIOException("Error flushing commits for table [" + this.table + "]", e);
        }
    }

    @Override
    public void close() {
        if (this.state.equals((Object)ReaderWriterState.OPEN)) {
            try {
                this.table.flushCommits();
                this.table.setAutoFlush(true);
                this.table.close();
            }
            catch (IOException e) {
                throw new DatasetIOException("Error closing table [" + this.table + "]", e);
            }
            this.state = ReaderWriterState.CLOSED;
        }
    }

    public boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }
}

