/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.SchemaNotFoundException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.hbase.avro.AvroEntityComposer;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroEntitySerDe;
import org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser;
import org.kitesdk.data.hbase.avro.AvroKeySchema;
import org.kitesdk.data.hbase.avro.AvroKeySerDe;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.impl.BaseEntityMapper;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.EntitySerDe;
import org.kitesdk.data.hbase.impl.HBaseUtils;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.KeySerDe;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.data.hbase.manager.generated.ManagedSchemaEntityVersion;
import org.kitesdk.data.spi.PartitionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedAvroEntityMapper<ENTITY extends IndexedRecord>
implements EntityMapper<ENTITY> {
    private static Logger LOG = LoggerFactory.getLogger(VersionedAvroEntityMapper.class);
    private static final AvroKeyEntitySchemaParser schemaParser = new AvroKeyEntitySchemaParser();
    private final SchemaManager schemaManager;
    private final String tableName;
    private final String entityName;
    private final Class<ENTITY> entityClass;
    private final AvroKeySchema keySchema;
    private final AvroEntitySchema entitySchema;
    private final int version;
    private final boolean specific;
    private final ConcurrentHashMap<Integer, EntityMapper<ENTITY>> entityMappers = new ConcurrentHashMap();
    private final String managedSchemaEntityVersionSchema;
    private EntityMapper<ManagedSchemaEntityVersion> managedSchemaEntityVersionEntityMapper;

    private VersionedAvroEntityMapper(Builder builder) {
        this.schemaManager = builder.schemaManager;
        this.tableName = builder.tableName;
        this.entityName = builder.entityName;
        this.specific = builder.specific;
        this.managedSchemaEntityVersionSchema = VersionedAvroEntityMapper.getManagedSchemaEntityVersionSchema(this.entityName);
        if (!this.specific) {
            this.entityClass = GenericRecord.class;
            this.keySchema = (AvroKeySchema)this.schemaManager.getKeySchema(this.tableName, this.entityName);
            this.entitySchema = builder.genericSchemaString != null ? schemaParser.parseEntitySchema(builder.genericSchemaString) : (AvroEntitySchema)this.schemaManager.getEntitySchema(this.tableName, this.entityName);
            this.version = this.schemaManager.getEntityVersion(this.tableName, this.entityName, this.entitySchema);
        } else {
            try {
                this.keySchema = (AvroKeySchema)this.schemaManager.getKeySchema(this.tableName, this.entityName);
                AvroEntitySchema mostRecentEntitySchema = (AvroEntitySchema)this.schemaManager.getEntitySchema(this.tableName, this.entityName);
                String entityClassName = mostRecentEntitySchema.getAvroSchema().getFullName();
                this.entityClass = Class.forName(entityClassName);
                String entitySchemaString = this.entityClass.getField("SCHEMA$").get(null).toString();
                this.entitySchema = schemaParser.parseEntitySchema(entitySchemaString);
                this.version = this.schemaManager.getEntityVersion(this.tableName, this.entityName, this.entitySchema);
            }
            catch (ClassNotFoundException e) {
                String msg = "StorageKey or entity class not found. Make sure the specific record instances are on the classpath.";
                LOG.error(msg, (Throwable)e);
                throw new DatasetException(msg, (Throwable)e);
            }
            catch (SecurityException e) {
                String msg = "Cannot access key or entity class.";
                LOG.error(msg, (Throwable)e);
                throw new DatasetException(msg, (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                String msg = "SCHEMA$ field not found in the entity class";
                LOG.error(msg, (Throwable)e);
                throw new DatasetException(msg, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                String msg = "Not allowed to access SCHEMA$ field in the entity class";
                LOG.error(msg, (Throwable)e);
                throw new DatasetException(msg, (Throwable)e);
            }
        }
        this.updateEntityMappers();
        this.initializeEntityVersionEntityMapper();
    }

    @Override
    public PartitionKey mapToKey(ENTITY entity) {
        return this.entityMappers.get(this.version).mapToKey(entity);
    }

    @Override
    public ENTITY mapToEntity(Result result) {
        ManagedSchemaEntityVersion versionRecord = this.managedSchemaEntityVersionEntityMapper.mapToEntity(result);
        int resultVersion = 0;
        if (versionRecord != null) {
            resultVersion = versionRecord.getSchemaVersion();
        }
        if (this.entityMappers.containsKey(resultVersion)) {
            return (ENTITY)((IndexedRecord)this.entityMappers.get(resultVersion).mapToEntity(result));
        }
        this.schemaManager.refreshManagedSchemaCache(this.tableName, this.entityName);
        this.updateEntityMappers();
        if (this.entityMappers.containsKey(resultVersion)) {
            return (ENTITY)((IndexedRecord)this.entityMappers.get(resultVersion).mapToEntity(result));
        }
        String msg = "Could not find schema for " + this.tableName + ", " + this.entityName + ", with version " + resultVersion;
        LOG.error(msg);
        throw new SchemaNotFoundException(msg);
    }

    @Override
    public PutAction mapFromEntity(ENTITY entity) {
        EntityMapper<ENTITY> entityMapper = this.entityMappers.get(this.version);
        PutAction entityPut = entityMapper.mapFromEntity(entity);
        ManagedSchemaEntityVersion versionRecord = ManagedSchemaEntityVersion.newBuilder().setSchemaVersion(this.version).build();
        PutAction versionPut = this.managedSchemaEntityVersionEntityMapper.mapFromEntity(versionRecord);
        byte[] keyBytes = entityPut.getPut().getRow();
        versionPut = HBaseUtils.mergePutActions(keyBytes, Arrays.asList(versionPut));
        return HBaseUtils.mergePutActions(keyBytes, Arrays.asList(entityPut, versionPut));
    }

    @Override
    public Increment mapToIncrement(PartitionKey key, String fieldName, long incrementValue) {
        return this.entityMappers.get(this.version).mapToIncrement(key, fieldName, incrementValue);
    }

    @Override
    public long mapFromIncrementResult(Result result, String fieldName) {
        return this.entityMappers.get(this.version).mapFromIncrementResult(result, fieldName);
    }

    @Override
    public Set<String> getRequiredColumns() {
        Set<String> requiredColumns = this.entityMappers.get(this.version).getRequiredColumns();
        requiredColumns.addAll(this.managedSchemaEntityVersionEntityMapper.getRequiredColumns());
        return requiredColumns;
    }

    @Override
    public Set<String> getRequiredColumnFamilies() {
        Set<String> requiredColumns = this.entityMappers.get(this.version).getRequiredColumnFamilies();
        requiredColumns.addAll(this.managedSchemaEntityVersionEntityMapper.getRequiredColumnFamilies());
        return requiredColumns;
    }

    @Override
    public KeySchema getKeySchema() {
        return this.keySchema;
    }

    @Override
    public EntitySchema getEntitySchema() {
        return this.entitySchema;
    }

    @Override
    public KeySerDe getKeySerDe() {
        return this.entityMappers.get(this.version).getKeySerDe();
    }

    @Override
    public EntitySerDe<ENTITY> getEntitySerDe() {
        return this.entityMappers.get(this.version).getEntitySerDe();
    }

    private void initializeEntityVersionEntityMapper() {
        AvroEntitySchema avroEntitySchema = schemaParser.parseEntitySchema(this.managedSchemaEntityVersionSchema);
        avroEntitySchema = AvroUtils.mergeSpecificStringTypes(ManagedSchemaEntityVersion.class, avroEntitySchema);
        AvroEntityComposer entityComposer = new AvroEntityComposer(avroEntitySchema, true);
        AvroEntitySerDe entitySerDe = new AvroEntitySerDe(entityComposer, avroEntitySchema, avroEntitySchema, true);
        this.managedSchemaEntityVersionEntityMapper = new BaseEntityMapper<ManagedSchemaEntityVersion>(avroEntitySchema, entitySerDe);
    }

    private void updateEntityMappers() {
        for (Map.Entry<Integer, EntitySchema> entry : this.schemaManager.getEntitySchemas(this.tableName, this.entityName).entrySet()) {
            if (this.entityMappers.containsKey(entry.getKey())) continue;
            AvroEntitySchema writtenSchema = (AvroEntitySchema)entry.getValue();
            EntityMapper<ENTITY> entityMapper = this.constructWrappedEntityMapper(this.keySchema, this.entitySchema, writtenSchema, this.entityClass);
            this.entityMappers.put(entry.getKey(), entityMapper);
        }
    }

    private EntityMapper<ENTITY> constructWrappedEntityMapper(AvroKeySchema keySchema, AvroEntitySchema readSchema, AvroEntitySchema writeSchema, Class entityClass) {
        if (this.specific) {
            keySchema = AvroUtils.mergeSpecificStringTypes((Class<? extends SpecificRecord>)entityClass, keySchema);
            readSchema = AvroUtils.mergeSpecificStringTypes((Class<? extends SpecificRecord>)entityClass, readSchema);
            AvroEntityComposer entityComposer = new AvroEntityComposer(readSchema, true);
            AvroEntitySerDe entitySerDe = new AvroEntitySerDe(entityComposer, readSchema, writeSchema, true);
            AvroKeySerDe keySerDe = new AvroKeySerDe(keySchema.getAvroSchema(), keySchema.getPartitionStrategy());
            return new BaseEntityMapper(keySchema, readSchema, keySerDe, entitySerDe);
        }
        AvroKeySerDe keySerDe = new AvroKeySerDe(keySchema.getAvroSchema(), keySchema.getPartitionStrategy());
        AvroEntityComposer entityComposer = new AvroEntityComposer(readSchema, false);
        AvroEntitySerDe entitySerDe = new AvroEntitySerDe(entityComposer, readSchema, writeSchema, false);
        return new BaseEntityMapper(keySchema, readSchema, keySerDe, entitySerDe);
    }

    private static String getManagedSchemaEntityVersionSchema(String entityName) {
        String avroSchemaString = AvroUtils.inputStreamToString(VersionedAvroEntityMapper.class.getResourceAsStream("/ManagedSchemaEntityVersion.avsc"));
        JsonNode jsonNode = VersionedAvroEntityMapper.rawSchemaAsJsonNode(avroSchemaString);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode mappingNode = mapper.createObjectNode();
        mappingNode.put("type", "column");
        mappingNode.put("value", "_s:sv_" + entityName);
        ((ObjectNode)jsonNode.get("fields").get(0)).put("mapping", (JsonNode)mappingNode);
        return jsonNode.toString();
    }

    private static JsonNode rawSchemaAsJsonNode(String rawSchema) {
        JsonNode avroRecordSchemaJson;
        ObjectMapper mapper = new ObjectMapper();
        try {
            avroRecordSchemaJson = (JsonNode)mapper.readValue(rawSchema, JsonNode.class);
        }
        catch (IOException e) {
            throw new ValidationException("Could not parse the avro record as JSON.", (Throwable)e);
        }
        return avroRecordSchemaJson;
    }

    public static class Builder {
        private SchemaManager schemaManager;
        private String tableName;
        private String entityName;
        private boolean specific;
        private String genericSchemaString;

        public Builder setSchemaManager(SchemaManager schemaManager) {
            this.schemaManager = schemaManager;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setEntityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public Builder setSpecific(boolean specific) {
            this.specific = specific;
            return this;
        }

        public Builder setGenericSchemaString(String genericSchemaString) {
            this.genericSchemaString = genericSchemaString;
            return this;
        }

        public <E extends IndexedRecord> VersionedAvroEntityMapper<E> build() {
            return new VersionedAvroEntityMapper(this);
        }
    }
}

