/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.Configurable;
import org.apache.flume.serialization.EventSerializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroEventSerializer
implements EventSerializer,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AvroEventSerializer.class);
    public static final String AVRO_SCHEMA_LITERAL_HEADER = "flume.avro.schema.literal";
    public static final String AVRO_SCHEMA_URL_HEADER = "flume.avro.schema.url";
    private final OutputStream out;
    private DatumWriter<Object> writer = null;
    private DataFileWriter<Object> dataFileWriter = null;
    private int syncIntervalBytes;
    private String compressionCodec;
    private Map<String, Schema> schemaCache = new HashMap<String, Schema>();

    private AvroEventSerializer(OutputStream out) {
        this.out = out;
    }

    public void configure(Context context) {
        this.syncIntervalBytes = context.getInteger("syncIntervalBytes", Integer.valueOf(2048000));
        this.compressionCodec = context.getString("compressionCodec", "null");
    }

    public void afterCreate() throws IOException {
    }

    public void afterReopen() throws IOException {
        throw new UnsupportedOperationException("Avro API doesn't support append");
    }

    public void write(Event event) throws IOException {
        if (this.dataFileWriter == null) {
            this.initialize(event);
        }
        this.dataFileWriter.appendEncoded(ByteBuffer.wrap(event.getBody()));
    }

    private void initialize(Event event) throws IOException {
        Schema schema = null;
        String schemaUrl = (String)event.getHeaders().get(AVRO_SCHEMA_URL_HEADER);
        if (schemaUrl != null && (schema = this.schemaCache.get(schemaUrl)) == null) {
            schema = this.loadFromUrl(schemaUrl);
            this.schemaCache.put(schemaUrl, schema);
        }
        if (schema == null) {
            String schemaString = (String)event.getHeaders().get(AVRO_SCHEMA_LITERAL_HEADER);
            if (schemaString == null) {
                throw new FlumeException("Could not find schema for event " + event);
            }
            schema = new Schema.Parser().parse(schemaString);
        }
        this.writer = new GenericDatumWriter(schema);
        this.dataFileWriter = new DataFileWriter(this.writer);
        this.dataFileWriter.setSyncInterval(this.syncIntervalBytes);
        try {
            CodecFactory codecFactory = CodecFactory.fromString((String)this.compressionCodec);
            this.dataFileWriter.setCodec(codecFactory);
        }
        catch (AvroRuntimeException e) {
            logger.warn("Unable to instantiate avro codec with name (" + this.compressionCodec + "). Compression disabled. Exception follows.", (Throwable)e);
        }
        this.dataFileWriter.create(schema, this.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema loadFromUrl(String schemaUrl) throws IOException {
        Configuration conf = new Configuration();
        Schema.Parser parser = new Schema.Parser();
        if (schemaUrl.toLowerCase().startsWith("hdfs://")) {
            FileSystem fs = FileSystem.get((Configuration)conf);
            FSDataInputStream input = null;
            try {
                input = fs.open(new Path(schemaUrl));
                Schema schema = parser.parse((InputStream)input);
                return schema;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        InputStream is = null;
        try {
            is = new URL(schemaUrl).openStream();
            Schema schema = parser.parse(is);
            return schema;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void flush() throws IOException {
        this.dataFileWriter.flush();
    }

    public void beforeClose() throws IOException {
    }

    public boolean supportsReopen() {
        return false;
    }

    public static class Builder
    implements EventSerializer.Builder {
        public EventSerializer build(Context context, OutputStream out) {
            AvroEventSerializer writer = new AvroEventSerializer(out);
            writer.configure(context);
            return writer;
        }
    }
}

