/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import com.google.common.base.Preconditions;
import java.util.Calendar;

public class TimestampRoundDownUtil {
    public static long roundDownTimeStampSeconds(long timestamp, int roundDownSec) throws IllegalStateException {
        Preconditions.checkArgument((roundDownSec > 0 && roundDownSec <= 60 ? 1 : 0) != 0, (Object)"RoundDownSec must be > 0 and <=60");
        Calendar cal = TimestampRoundDownUtil.roundDownField(timestamp, 13, roundDownSec);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long roundDownTimeStampMinutes(long timestamp, int roundDownMins) throws IllegalStateException {
        Preconditions.checkArgument((roundDownMins > 0 && roundDownMins <= 60 ? 1 : 0) != 0, (Object)"RoundDown must be > 0 and <=60");
        Calendar cal = TimestampRoundDownUtil.roundDownField(timestamp, 12, roundDownMins);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long roundDownTimeStampHours(long timestamp, int roundDownHours) throws IllegalStateException {
        Preconditions.checkArgument((roundDownHours > 0 && roundDownHours <= 24 ? 1 : 0) != 0, (Object)"RoundDown must be > 0 and <=24");
        Calendar cal = TimestampRoundDownUtil.roundDownField(timestamp, 11, roundDownHours);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static Calendar roundDownField(long timestamp, int field, int roundDown) {
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must be positive");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        int fieldVal = cal.get(field);
        int remainder = fieldVal % roundDown;
        cal.set(field, fieldVal - remainder);
        return cal;
    }
}

