/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import java.util.ArrayList;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.generated.ClientPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class AtomicIncrementRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifier,
HBaseRpc.IsEdit {
    private static final byte[] INCREMENT_COLUMN_VALUE = new byte[]{105, 110, 99, 114, 101, 109, 101, 110, 116, 67, 111, 108, 117, 109, 110, 86, 97, 108, 117, 101};
    private final byte[] family;
    private final byte[] qualifier;
    private long amount;
    private boolean durable = true;

    public AtomicIncrementRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, long amount) {
        super(table, key);
        KeyValue.checkFamily(family);
        KeyValue.checkQualifier(qualifier);
        this.family = family;
        this.qualifier = qualifier;
        this.amount = amount;
    }

    public AtomicIncrementRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier) {
        this(table, key, family, qualifier, 1L);
    }

    public AtomicIncrementRequest(String table, String key, String family, String qualifier, long amount) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), amount);
    }

    public AtomicIncrementRequest(String table, String key, String family, String qualifier) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), 1L);
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    byte[] method(byte server_version) {
        return server_version >= 95 ? MUTATE : INCREMENT_COLUMN_VALUE;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] family() {
        return this.family;
    }

    @Override
    public byte[] qualifier() {
        return this.qualifier;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifier("AtomicIncrementRequest", this.family, this.qualifier, ", amount=" + this.amount);
    }

    void setDurable(boolean durable) {
        this.durable = durable;
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        size += 3;
        size += this.key.length;
        ++size;
        ++size;
        size += this.family.length;
        ++size;
        size += 3;
        size += this.qualifier.length;
        ++size;
        size += 8;
        ++size;
        return ++size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ClientPB.MutationProto.ColumnValue.QualifierValue qualifier = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(this.qualifier)).setValue(Bytes.wrap(Bytes.fromLong(this.amount))).build();
        ClientPB.MutationProto.ColumnValue column = ClientPB.MutationProto.ColumnValue.newBuilder().setFamily(Bytes.wrap(this.family)).addQualifierValue(qualifier).build();
        ClientPB.MutationProto.Builder incr = ClientPB.MutationProto.newBuilder().setRow(Bytes.wrap(this.key)).setMutateType(ClientPB.MutationProto.MutationType.INCREMENT).addColumnValue(column);
        if (!this.durable) {
            incr.setDurability(ClientPB.MutationProto.Durability.SKIP_WAL);
        }
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(incr.build()).build();
        return AtomicIncrementRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(6);
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.region.name());
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.key);
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.family);
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.qualifier);
        AtomicIncrementRequest.writeHBaseLong(buf, this.amount);
        AtomicIncrementRequest.writeHBaseBool(buf, this.durable);
        return buf;
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        ClientPB.MutateResponse resp = AtomicIncrementRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        ArrayList<KeyValue> kvs = GetRequest.convertResult(resp.getResult(), buf, cell_size);
        if (kvs.size() != 1) {
            throw new InvalidResponseException("Atomic increment returned " + kvs.size() + " KeyValue(s), but we expected exactly one. kvs=" + kvs, (Object)resp);
        }
        return Bytes.getLong(kvs.get(0).value());
    }
}

