/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ZkSecurityMigrator;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class ZkSecurityMigrator$
implements Logging {
    public static final ZkSecurityMigrator$ MODULE$ = new ZkSecurityMigrator$();
    private static final String usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    private static final String tlsConfigFileOption = "zk-tls-config-file";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String usageMessage() {
        return usageMessage;
    }

    public String tlsConfigFileOption() {
        return tlsConfigFileOption;
    }

    public void run(String[] args) {
        None$ none$;
        String string;
        String string2;
        boolean bl;
        ZKClientConfig zkClientConfig;
        ZkSecurityMigrator.ZkSecurityMigratorOptions opts;
        block14: {
            block12: {
                block13: {
                    Object object;
                    String jaasFile = System.getProperty("java.security.auth.login.config");
                    opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
                    CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
                    Option<ZKClientConfig> option = this.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile());
                    if (option == null) {
                        throw null;
                    }
                    Option<ZKClientConfig> getOrElse_this = option;
                    if (getOrElse_this.isEmpty()) {
                        ZKClientConfig zKClientConfig;
                        ZKClientConfig zKClientConfig2 = zKClientConfig = new ZKClientConfig();
                        zKClientConfig = null;
                        object = zKClientConfig2;
                    } else {
                        object = getOrElse_this.get();
                    }
                    Object object2 = object;
                    Object var20_4 = null;
                    object = null;
                    zkClientConfig = (ZKClientConfig)object2;
                    boolean tlsClientAuthEnabled = KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
                    if (jaasFile == null && !tlsClientAuthEnabled) {
                        String errorMsg = new StringBuilder(0).append("No JAAS configuration file has been specified and no TLS client certificate has been specified. Please make sure that you set ").append(new StringBuilder(118).append("the system property ").append("java.security.auth.login.config").append(" or provide a ZooKeeper client TLS configuration via --").append(this.tlsConfigFileOption()).append(" <filename> ").toString()).append(new StringBuilder(29).append("identifying at least ").append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).append(", ").append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).append(", and ").append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString()).toString();
                        System.err.println(StringOps$.MODULE$.format$extension("ERROR: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                        throw new IllegalArgumentException("Incorrect configuration");
                    }
                    if (!tlsClientAuthEnabled && !JaasUtils.isZkSaslEnabled()) {
                        String errorMsg = StringOps$.MODULE$.format$extension("Security isn't enabled, most likely the file isn't set properly: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{jaasFile}));
                        System.out.println(StringOps$.MODULE$.format$extension("ERROR: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                        throw new IllegalArgumentException("Incorrect configuration");
                    }
                    String string3 = (String)opts.options().valueOf(opts.zkAclOpt());
                    switch (string3 == null ? 0 : string3.hashCode()) {
                        case -906273929: {
                            if ("secure".equals(string3)) {
                                break;
                            }
                            break block12;
                        }
                        case -19770544: {
                            if (!"unsecure".equals(string3)) break block12;
                            break block13;
                        }
                        default: {
                            break block12;
                        }
                    }
                    if (this.logger().underlying().isInfoEnabled()) {
                        String string4;
                        String string5 = string4 = "zookeeper.acl option is secure";
                        string4 = null;
                        String msgWithLogIdent_msg = string5;
                        Object var25_13 = null;
                        this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    bl = true;
                    break block14;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    String string6;
                    String string7 = string6 = "zookeeper.acl option is unsecure";
                    string6 = null;
                    String msgWithLogIdent_msg = string7;
                    Object var26_16 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                bl = false;
                break block14;
            }
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), this.usageMessage());
        }
        String zkUrl = (String)opts.options().valueOf(opts.zkUrlOpt());
        int zkSessionTimeout = (Integer)opts.options().valueOf(opts.zkSessionTimeoutOpt());
        int zkConnectionTimeout = (Integer)opts.options().valueOf(opts.zkConnectionTimeoutOpt());
        Time x$6 = Time.SYSTEM;
        Some x$7 = new Some((Object)zkClientConfig);
        String string8 = string2 = "kafka.server";
        string2 = null;
        String x$8 = string8;
        String string9 = string = "SessionExpireListener";
        string = null;
        String x$9 = string9;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$2;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, bl, zkSessionTimeout, zkConnectionTimeout, Integer.MAX_VALUE, x$6, x$8, x$9, (Option<String>)x$10, (Option<ZKClientConfig>)x$7);
        boolean enablePathCheck = opts.options().has((OptionSpec)opts.enablePathCheckOpt());
        new ZkSecurityMigrator(zkClient).kafka$admin$ZkSecurityMigrator$$run(enablePathCheck);
    }

    public void main(String[] args) {
        try {
            this.run(args);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZKClientConfig createZkClientConfigFromFile(String filename) {
        void var3_3;
        Properties zkTlsConfigFileProps = Utils.loadProps((String)filename, (List)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().toList()).asJava());
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$1(zkTlsConfigFileProps, filename);
            Object var4_4 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)zkTlsConfigFileProps).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
            ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$2(zkClientConfig, key, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return var3_3;
    }

    public Option<ZKClientConfig> createZkClientConfigFromOption(OptionSet options, ArgumentAcceptingOptionSpec<String> option) {
        if (!options.has(option)) {
            return None$.MODULE$;
        }
        return new Some((Object)this.createZkClientConfigFromFile((String)options.valueOf(option)));
    }

    public static final /* synthetic */ ZKClientConfig $anonfun$run$1() {
        return new ZKClientConfig();
    }

    public static final /* synthetic */ String $anonfun$run$2() {
        return "zookeeper.acl option is secure";
    }

    public static final /* synthetic */ String $anonfun$run$3() {
        return "zookeeper.acl option is unsecure";
    }

    public static final /* synthetic */ String $anonfun$createZkClientConfigFromFile$1(Properties zkTlsConfigFileProps$1, String filename$1) {
        return new StringBuilder(57).append("Found ").append(zkTlsConfigFileProps$1.size()).append(" ZooKeeper client configuration properties in file ").append(filename$1).toString();
    }

    public static final /* synthetic */ String $anonfun$createZkClientConfigFromFile$3(String key$1) {
        return new StringBuilder(8).append("Setting ").append(key$1).toString();
    }

    public static final /* synthetic */ void $anonfun$createZkClientConfigFromFile$2(ZKClientConfig zkClientConfig$1, String key, String value) {
        ZkSecurityMigrator$ info_this = MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$3(key);
            Object var4_4 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
        }
        Object var3_3 = null;
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(zkClientConfig$1, key, value);
    }

    private ZkSecurityMigrator$() {
    }
}

