/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.shared.kafka;

import java.util.Properties;
import org.apache.flume.util.SSLUtil;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaSSLUtil {
    public static final String SSL_DISABLE_FQDN_CHECK = "ssl.disableTLSHostnameVerification";

    private KafkaSSLUtil() {
    }

    public static void addGlobalSSLParameters(Properties kafkaProps) {
        if (KafkaSSLUtil.isSSLEnabled(kafkaProps)) {
            KafkaSSLUtil.addGlobalSSLParameter(kafkaProps, "ssl.keystore.location", SSLUtil.getGlobalKeystorePath());
            KafkaSSLUtil.addGlobalSSLParameter(kafkaProps, "ssl.keystore.password", SSLUtil.getGlobalKeystorePassword());
            KafkaSSLUtil.addGlobalSSLParameter(kafkaProps, "ssl.keystore.type", SSLUtil.getGlobalKeystoreType(null));
            KafkaSSLUtil.addGlobalSSLParameter(kafkaProps, "ssl.truststore.location", SSLUtil.getGlobalTruststorePath());
            KafkaSSLUtil.addGlobalSSLParameter(kafkaProps, "ssl.truststore.password", SSLUtil.getGlobalTruststorePassword());
            KafkaSSLUtil.addGlobalSSLParameter(kafkaProps, "ssl.truststore.type", SSLUtil.getGlobalTruststoreType(null));
        }
    }

    private static void addGlobalSSLParameter(Properties kafkaProps, String propName, String globalValue) {
        if (!kafkaProps.containsKey(propName) && globalValue != null) {
            kafkaProps.put(propName, globalValue);
        }
    }

    public static boolean isSSLEnabled(Properties kafkaProps) {
        String securityProtocol = kafkaProps.getProperty("security.protocol");
        return securityProtocol != null && (securityProtocol.equals(SecurityProtocol.SSL.name) || securityProtocol.equals(SecurityProtocol.SASL_SSL.name));
    }
}

