/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalKvState;

abstract class AbstractBatchExecutionKeyState<K, N, V>
implements InternalKvState<K, N, V> {
    private final V defaultValue;
    private final TypeSerializer<V> stateTypeSerializer;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<N> namespaceSerializer;
    private final Map<N, V> valuesForNamespaces = new HashMap<N, V>();
    private N currentNamespace;
    private V currentNamespaceValue;

    protected AbstractBatchExecutionKeyState(V defaultValue, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> stateTypeSerializer) {
        this.defaultValue = defaultValue;
        this.stateTypeSerializer = stateTypeSerializer;
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
    }

    V getOrDefault() {
        if (this.currentNamespaceValue == null && this.defaultValue != null) {
            return this.stateTypeSerializer.copy(this.defaultValue);
        }
        return this.currentNamespaceValue;
    }

    public V getCurrentNamespaceValue() {
        return this.currentNamespaceValue;
    }

    public void setCurrentNamespaceValue(V currentNamespaceValue) {
        this.currentNamespaceValue = currentNamespaceValue;
    }

    @Override
    public TypeSerializer<V> getValueSerializer() {
        return this.stateTypeSerializer;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        if (Objects.equals(this.currentNamespace, namespace)) {
            return;
        }
        if (this.currentNamespace != null) {
            if (this.currentNamespaceValue == null) {
                this.valuesForNamespaces.remove(this.currentNamespace);
            } else {
                this.valuesForNamespaces.put(this.currentNamespace, this.currentNamespaceValue);
            }
        }
        this.currentNamespaceValue = this.valuesForNamespaces.get(namespace);
        this.currentNamespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) {
        throw new UnsupportedOperationException("Queryable state is not supported in BATCH runtime.");
    }

    @Override
    public InternalKvState.StateIncrementalVisitor<K, N, V> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return null;
    }

    @Override
    public void clear() {
        this.currentNamespaceValue = null;
        this.valuesForNamespaces.remove(this.currentNamespace);
    }

    void clearAllNamespaces() {
        this.currentNamespaceValue = null;
        this.currentNamespace = null;
        this.valuesForNamespaces.clear();
    }
}

