/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestConstants;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedFile;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerUtils.class);
    private static final ObjectMapper mapper = RestMapperUtils.getStrictObjectMapper();

    public static <P extends ResponseBody> CompletableFuture<Void> sendResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, P response, HttpResponseStatus statusCode, Map<String, String> headers) {
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue(sw, response);
        }
        catch (IOException ioe) {
            LOG.error("Internal server error. Could not map response to JSON.", (Throwable)ioe);
            return HandlerUtils.sendErrorResponse(channelHandlerContext, httpRequest, new ErrorResponseBody("Internal server error. Could not map response to JSON."), HttpResponseStatus.INTERNAL_SERVER_ERROR, headers);
        }
        return HandlerUtils.sendResponse(channelHandlerContext, httpRequest, sw.toString(), statusCode, headers);
    }

    public static CompletableFuture<Void> sendErrorResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, ErrorResponseBody errorMessage, HttpResponseStatus statusCode, Map<String, String> headers) {
        return HandlerUtils.sendErrorResponse(channelHandlerContext, HttpHeaders.isKeepAlive((HttpMessage)httpRequest), errorMessage, statusCode, headers);
    }

    public static CompletableFuture<Void> sendErrorResponse(ChannelHandlerContext channelHandlerContext, boolean keepAlive, ErrorResponseBody errorMessage, HttpResponseStatus statusCode, Map<String, String> headers) {
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue(sw, (Object)errorMessage);
        }
        catch (IOException e) {
            LOG.error("Internal server error. Could not map error response to JSON.", (Throwable)e);
            return HandlerUtils.sendResponse(channelHandlerContext, keepAlive, "Internal server error. Could not map error response to JSON.", HttpResponseStatus.INTERNAL_SERVER_ERROR, headers);
        }
        return HandlerUtils.sendResponse(channelHandlerContext, keepAlive, sw.toString(), statusCode, headers);
    }

    public static CompletableFuture<Void> sendResponse(@Nonnull ChannelHandlerContext channelHandlerContext, @Nonnull HttpRequest httpRequest, @Nonnull String message, @Nonnull HttpResponseStatus statusCode, @Nonnull Map<String, String> headers) {
        return HandlerUtils.sendResponse(channelHandlerContext, HttpHeaders.isKeepAlive((HttpMessage)httpRequest), message, statusCode, headers);
    }

    public static CompletableFuture<Void> sendResponse(@Nonnull ChannelHandlerContext channelHandlerContext, boolean keepAlive, @Nonnull String message, @Nonnull HttpResponseStatus statusCode, @Nonnull Map<String, String> headers) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.headers().set("Content-Type", (Object)RestConstants.REST_CONTENT_TYPE);
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            response.headers().set(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        if (keepAlive) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        byte[] buf = message.getBytes(ConfigConstants.DEFAULT_CHARSET);
        ByteBuf b = Unpooled.copiedBuffer((byte[])buf);
        HttpHeaders.setContentLength((HttpMessage)response, (long)buf.length);
        channelHandlerContext.write((Object)response);
        channelHandlerContext.write((Object)b);
        ChannelFuture lastContentFuture = channelHandlerContext.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return HandlerUtils.toCompletableFuture(lastContentFuture);
    }

    public static void transferFile(ChannelHandlerContext ctx, File file, HttpRequest httpRequest) throws FlinkException {
        RandomAccessFile randomAccessFile;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new FlinkException("Can not find file " + file + ".", e);
        }
        try {
            long fileLength = randomAccessFile.length();
            FileChannel fileChannel = randomAccessFile.getChannel();
            try {
                ChannelFuture lastContentFuture;
                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                response.headers().set("Content-Type", (Object)"text/plain");
                if (HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
                    response.headers().set("Connection", (Object)"keep-alive");
                }
                HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
                ctx.write((Object)response);
                GenericFutureListener completionListener = future -> {
                    fileChannel.close();
                    randomAccessFile.close();
                };
                if (ctx.pipeline().get(SslHandler.class) == null) {
                    ctx.write((Object)new DefaultFileRegion(fileChannel, 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise()).addListener(completionListener);
                    lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                } else {
                    lastContentFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(randomAccessFile, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise()).addListener(completionListener);
                }
                if (!HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
                    lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
            catch (IOException ex) {
                fileChannel.close();
                throw ex;
            }
        }
        catch (IOException ioe) {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                throw new FlinkException("Close file or channel error.", e);
            }
            throw new FlinkException("Could not transfer file " + file + " to the client.", ioe);
        }
    }

    private static CompletableFuture<Void> toCompletableFuture(ChannelFuture channelFuture) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                completableFuture.complete(null);
            } else {
                completableFuture.completeExceptionally(future.cause());
            }
        });
        return completableFuture;
    }
}

