/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import java.util.Collections;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.StartingScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousCompactorStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousCompactorStartingScanner.class);

    @Override
    public DataTableScan.DataFilePlan getPlan(SnapshotManager snapshotManager, DataTableScan scan) {
        Long latestSnapshotId = snapshotManager.latestSnapshotId();
        Long earliestSnapshotId = snapshotManager.earliestSnapshotId();
        if (latestSnapshotId == null || earliestSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
            return null;
        }
        for (long id = latestSnapshotId.longValue(); id >= earliestSnapshotId; --id) {
            Snapshot snapshot = snapshotManager.snapshot(id);
            if (snapshot.commitKind() != Snapshot.CommitKind.COMPACT) continue;
            LOG.debug("Found latest compact snapshot {}, reading from the next snapshot.", (Object)id);
            return new DataTableScan.DataFilePlan(id, Collections.emptyList());
        }
        LOG.debug("No compact snapshot found, reading from the earliest snapshot {}.", (Object)earliestSnapshotId);
        return new DataTableScan.DataFilePlan(earliestSnapshotId - 1L, Collections.emptyList());
    }
}

