/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.CorruptConfigurationException;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.util.config.memory.ManagedMemoryUtils;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.graph.NonChainedOutput;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.tasks.StreamTaskException;
import org.apache.flink.util.ClassLoaderUtil;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;
import org.apache.flink.util.concurrent.FutureUtils;

@Internal
public class StreamConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    public static final String SERIALIZEDUDF = "serializedUDF";
    private static final String NUMBER_OF_OUTPUTS = "numberOfOutputs";
    private static final String NUMBER_OF_NETWORK_INPUTS = "numberOfNetworkInputs";
    private static final String CHAINED_OUTPUTS = "chainedOutputs";
    private static final String CHAINED_TASK_CONFIG = "chainedTaskConfig_";
    private static final String IS_CHAINED_VERTEX = "isChainedSubtask";
    private static final String CHAIN_INDEX = "chainIndex";
    private static final String VERTEX_NAME = "vertexID";
    private static final String ITERATION_ID = "iterationId";
    private static final String INPUTS = "inputs";
    private static final String TYPE_SERIALIZER_OUT_1 = "typeSerializer_out";
    private static final String TYPE_SERIALIZER_SIDEOUT_PREFIX = "typeSerializer_sideout_";
    private static final String ITERATON_WAIT = "iterationWait";
    private static final String OP_NONCHAINED_OUTPUTS = "opNonChainedOutputs";
    private static final String VERTEX_NONCHAINED_OUTPUTS = "vertexNonChainedOutputs";
    private static final String IN_STREAM_EDGES = "inStreamEdges";
    private static final String OPERATOR_NAME = "operatorName";
    private static final String OPERATOR_ID = "operatorID";
    private static final String CHAIN_END = "chainEnd";
    private static final String GRAPH_CONTAINING_LOOPS = "graphContainingLoops";
    private static final String CHECKPOINTING_ENABLED = "checkpointing";
    private static final String CHECKPOINT_MODE = "checkpointMode";
    private static final String SAVEPOINT_DIR = "savepointdir";
    private static final String CHECKPOINT_STORAGE = "checkpointstorage";
    private static final String STATE_BACKEND = "statebackend";
    private static final String ENABLE_CHANGE_LOG_STATE_BACKEND = "enablechangelog";
    private static final String TIMER_SERVICE_PROVIDER = "timerservice";
    private static final String STATE_PARTITIONER = "statePartitioner";
    private static final String STATE_KEY_SERIALIZER = "statekeyser";
    private static final String TIME_CHARACTERISTIC = "timechar";
    private static final String MANAGED_MEMORY_FRACTION_PREFIX = "managedMemFraction.";
    private static final ConfigOption<Boolean> STATE_BACKEND_USE_MANAGED_MEMORY = ConfigOptions.key("statebackend.useManagedMemory").booleanType().noDefaultValue().withDescription("If state backend is specified, whether it uses managed memory.");
    private static final CheckpointingMode DEFAULT_CHECKPOINTING_MODE = CheckpointingMode.EXACTLY_ONCE;
    private static final double DEFAULT_MANAGED_MEMORY_FRACTION = 0.0;
    private final Configuration config;
    private final transient Map<String, Object> toBeSerializedConfigObjects = new HashMap<String, Object>();
    private final transient Map<Integer, CompletableFuture<StreamConfig>> chainedTaskFutures = new HashMap<Integer, CompletableFuture<StreamConfig>>();
    private final transient CompletableFuture<StreamConfig> serializationFuture = new CompletableFuture();

    public StreamConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public CompletableFuture<StreamConfig> getSerializationFuture() {
        return this.serializationFuture;
    }

    public CompletableFuture<StreamConfig> triggerSerializationAndReturnFuture(Executor ioExecutor) {
        FutureUtils.combineAll(this.chainedTaskFutures.values()).thenAcceptAsync(chainedConfigs -> {
            try {
                this.serializeAllConfigs();
                InstantiationUtil.writeObjectToConfig(chainedConfigs.stream().collect(Collectors.toMap(StreamConfig::getVertexID, Function.identity())), this.config, CHAINED_TASK_CONFIG);
                this.serializationFuture.complete(this);
            }
            catch (Throwable throwable) {
                this.serializationFuture.completeExceptionally(throwable);
            }
        }, ioExecutor);
        return this.serializationFuture;
    }

    public void serializeAllConfigs() {
        this.toBeSerializedConfigObjects.forEach((key, object) -> {
            try {
                InstantiationUtil.writeObjectToConfig(object, this.config, key);
            }
            catch (IOException e) {
                throw new StreamTaskException(String.format("Could not serialize object for key %s.", key), e);
            }
        });
    }

    @VisibleForTesting
    public void setAndSerializeTransitiveChainedTaskConfigs(Map<Integer, StreamConfig> chainedTaskConfigs) {
        try {
            InstantiationUtil.writeObjectToConfig(chainedTaskConfigs, this.config, CHAINED_TASK_CONFIG);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize object for key chained task config.", e);
        }
    }

    public void setVertexID(Integer vertexID) {
        this.config.setInteger(VERTEX_NAME, (int)vertexID);
    }

    public Integer getVertexID() {
        return this.config.getInteger(VERTEX_NAME, -1);
    }

    public void setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase managedMemoryUseCase, double fraction) {
        ConfigOption<Double> configOption = StreamConfig.getManagedMemoryFractionConfigOption(managedMemoryUseCase);
        Preconditions.checkArgument(fraction >= 0.0 && fraction <= 1.0, String.format("%s should be in range [0.0, 1.0], but was: %s", configOption.key(), fraction));
        this.config.setDouble(configOption, fraction);
    }

    public double getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase managedMemoryUseCase, Configuration taskManagerConfig, ClassLoader cl) {
        return ManagedMemoryUtils.convertToFractionOfSlot(managedMemoryUseCase, this.config.getDouble(StreamConfig.getManagedMemoryFractionConfigOption(managedMemoryUseCase)), this.getAllManagedMemoryUseCases(), taskManagerConfig, this.config.getOptional(STATE_BACKEND_USE_MANAGED_MEMORY), cl);
    }

    private static ConfigOption<Double> getManagedMemoryFractionConfigOption(ManagedMemoryUseCase managedMemoryUseCase) {
        return ConfigOptions.key(MANAGED_MEMORY_FRACTION_PREFIX + (Object)((Object)Preconditions.checkNotNull(managedMemoryUseCase))).doubleType().defaultValue(0.0);
    }

    private Set<ManagedMemoryUseCase> getAllManagedMemoryUseCases() {
        return this.config.keySet().stream().filter(key -> key.startsWith(MANAGED_MEMORY_FRACTION_PREFIX)).map(key -> ManagedMemoryUseCase.valueOf(key.replaceFirst(MANAGED_MEMORY_FRACTION_PREFIX, ""))).collect(Collectors.toSet());
    }

    public void setTimeCharacteristic(TimeCharacteristic characteristic) {
        this.config.setInteger(TIME_CHARACTERISTIC, characteristic.ordinal());
    }

    public TimeCharacteristic getTimeCharacteristic() {
        int ordinal = this.config.getInteger(TIME_CHARACTERISTIC, -1);
        if (ordinal >= 0) {
            return TimeCharacteristic.values()[ordinal];
        }
        throw new CorruptConfigurationException("time characteristic is not set");
    }

    public void setTypeSerializerOut(TypeSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_OUT_1, serializer);
    }

    public <T> TypeSerializer<T> getTypeSerializerOut(ClassLoader cl) {
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig(this.config, TYPE_SERIALIZER_OUT_1, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate serializer.", e);
        }
    }

    public void setTypeSerializerSideOut(OutputTag<?> outputTag, TypeSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_SIDEOUT_PREFIX + outputTag.getId(), serializer);
    }

    private void setTypeSerializer(String key, TypeSerializer<?> typeWrapper) {
        this.toBeSerializedConfigObjects.put(key, typeWrapper);
    }

    public <T> TypeSerializer<T> getTypeSerializerSideOut(OutputTag<?> outputTag, ClassLoader cl) {
        Preconditions.checkNotNull(outputTag, "Side output id must not be null.");
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig(this.config, TYPE_SERIALIZER_SIDEOUT_PREFIX + outputTag.getId(), cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate serializer.", e);
        }
    }

    public void setupNetworkInputs(TypeSerializer<?> ... serializers) {
        InputConfig[] inputs = new InputConfig[serializers.length];
        for (int i = 0; i < serializers.length; ++i) {
            inputs[i] = new NetworkInputConfig(serializers[i], i, InputRequirement.PASS_THROUGH);
        }
        this.setInputs(inputs);
    }

    public void setInputs(InputConfig ... inputs) {
        this.toBeSerializedConfigObjects.put(INPUTS, inputs);
    }

    public InputConfig[] getInputs(ClassLoader cl) {
        try {
            InputConfig[] inputs = (InputConfig[])InstantiationUtil.readObjectFromConfig(this.config, INPUTS, cl);
            if (inputs == null) {
                return new InputConfig[0];
            }
            return inputs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not deserialize inputs", e);
        }
    }

    @Deprecated
    public <T> TypeSerializer<T> getTypeSerializerIn1(ClassLoader cl) {
        return this.getTypeSerializerIn(0, cl);
    }

    @Deprecated
    public <T> TypeSerializer<T> getTypeSerializerIn2(ClassLoader cl) {
        return this.getTypeSerializerIn(1, cl);
    }

    public <T> TypeSerializer<T> getTypeSerializerIn(int index, ClassLoader cl) {
        InputConfig[] inputs = this.getInputs(cl);
        Preconditions.checkState(index < inputs.length);
        Preconditions.checkState(inputs[index] instanceof NetworkInputConfig, "Input [%s] was assumed to be network input", index);
        return ((NetworkInputConfig)inputs[index]).typeSerializer;
    }

    @VisibleForTesting
    public void setStreamOperator(StreamOperator<?> operator) {
        this.setStreamOperatorFactory(SimpleOperatorFactory.of(operator));
    }

    public void setStreamOperatorFactory(StreamOperatorFactory<?> factory) {
        if (factory != null) {
            this.toBeSerializedConfigObjects.put(SERIALIZEDUDF, factory);
        }
    }

    @VisibleForTesting
    public <T extends StreamOperator<?>> T getStreamOperator(ClassLoader cl) {
        SimpleOperatorFactory factory = (SimpleOperatorFactory)this.getStreamOperatorFactory(cl);
        return (T)factory.getOperator();
    }

    public <T extends StreamOperatorFactory<?>> T getStreamOperatorFactory(ClassLoader cl) {
        try {
            return (T)((StreamOperatorFactory)InstantiationUtil.readObjectFromConfig(this.config, SERIALIZEDUDF, cl));
        }
        catch (ClassNotFoundException e) {
            String classLoaderInfo = ClassLoaderUtil.getUserCodeClassLoaderInfo(cl);
            boolean loadableDoubleCheck = ClassLoaderUtil.validateClassLoadable(e, cl);
            String exceptionMessage = "Cannot load user class: " + e.getMessage() + "\nClassLoader info: " + classLoaderInfo + (loadableDoubleCheck ? "\nClass was actually found in classloader - deserialization issue." : "\nClass not resolvable through given classloader.");
            throw new StreamTaskException(exceptionMessage, e);
        }
        catch (Exception e) {
            throw new StreamTaskException("Cannot instantiate user function.", e);
        }
    }

    public void setIterationId(String iterationId) {
        this.config.setString(ITERATION_ID, iterationId);
    }

    public String getIterationId() {
        return this.config.getString(ITERATION_ID, "");
    }

    public void setIterationWaitTime(long time) {
        this.config.setLong(ITERATON_WAIT, time);
    }

    public long getIterationWaitTime() {
        return this.config.getLong(ITERATON_WAIT, 0L);
    }

    public void setNumberOfNetworkInputs(int numberOfInputs) {
        this.config.setInteger(NUMBER_OF_NETWORK_INPUTS, numberOfInputs);
    }

    public int getNumberOfNetworkInputs() {
        return this.config.getInteger(NUMBER_OF_NETWORK_INPUTS, 0);
    }

    public void setNumberOfOutputs(int numberOfOutputs) {
        this.config.setInteger(NUMBER_OF_OUTPUTS, numberOfOutputs);
    }

    public int getNumberOfOutputs() {
        return this.config.getInteger(NUMBER_OF_OUTPUTS, 0);
    }

    public void setOperatorNonChainedOutputs(List<NonChainedOutput> nonChainedOutputs) {
        this.toBeSerializedConfigObjects.put(OP_NONCHAINED_OUTPUTS, nonChainedOutputs);
    }

    public List<NonChainedOutput> getOperatorNonChainedOutputs(ClassLoader cl) {
        try {
            List nonChainedOutputs = (List)InstantiationUtil.readObjectFromConfig(this.config, OP_NONCHAINED_OUTPUTS, cl);
            return nonChainedOutputs == null ? new ArrayList() : nonChainedOutputs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate non chained outputs.", e);
        }
    }

    public void setChainedOutputs(List<StreamEdge> chainedOutputs) {
        this.toBeSerializedConfigObjects.put(CHAINED_OUTPUTS, chainedOutputs);
    }

    public List<StreamEdge> getChainedOutputs(ClassLoader cl) {
        try {
            List chainedOutputs = (List)InstantiationUtil.readObjectFromConfig(this.config, CHAINED_OUTPUTS, cl);
            return chainedOutputs == null ? new ArrayList() : chainedOutputs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate chained outputs.", e);
        }
    }

    public void setInPhysicalEdges(List<StreamEdge> inEdges) {
        this.toBeSerializedConfigObjects.put(IN_STREAM_EDGES, inEdges);
    }

    public List<StreamEdge> getInPhysicalEdges(ClassLoader cl) {
        try {
            List inEdges = (List)InstantiationUtil.readObjectFromConfig(this.config, IN_STREAM_EDGES, cl);
            return inEdges == null ? new ArrayList() : inEdges;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate inputs.", e);
        }
    }

    public void setCheckpointingEnabled(boolean enabled) {
        this.config.setBoolean(CHECKPOINTING_ENABLED, enabled);
    }

    public boolean isCheckpointingEnabled() {
        return this.config.getBoolean(CHECKPOINTING_ENABLED, false);
    }

    public void setCheckpointMode(CheckpointingMode mode) {
        this.config.setInteger(CHECKPOINT_MODE, mode.ordinal());
    }

    public CheckpointingMode getCheckpointMode() {
        int ordinal = this.config.getInteger(CHECKPOINT_MODE, -1);
        if (ordinal >= 0) {
            return CheckpointingMode.values()[ordinal];
        }
        return DEFAULT_CHECKPOINTING_MODE;
    }

    public void setUnalignedCheckpointsEnabled(boolean enabled) {
        this.config.setBoolean(ExecutionCheckpointingOptions.ENABLE_UNALIGNED, enabled);
    }

    public boolean isUnalignedCheckpointsEnabled() {
        return this.config.getBoolean(ExecutionCheckpointingOptions.ENABLE_UNALIGNED, false);
    }

    public boolean isExactlyOnceCheckpointMode() {
        return this.getCheckpointMode() == CheckpointingMode.EXACTLY_ONCE;
    }

    public Duration getAlignedCheckpointTimeout() {
        return this.config.get(ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT);
    }

    public void setAlignedCheckpointTimeout(Duration alignedCheckpointTimeout) {
        this.config.set((ConfigOption)ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT, alignedCheckpointTimeout);
    }

    public void setVertexNonChainedOutputs(List<NonChainedOutput> nonChainedOutputs) {
        this.toBeSerializedConfigObjects.put(VERTEX_NONCHAINED_OUTPUTS, nonChainedOutputs);
    }

    public List<NonChainedOutput> getVertexNonChainedOutputs(ClassLoader cl) {
        try {
            List nonChainedOutputs = (List)InstantiationUtil.readObjectFromConfig(this.config, VERTEX_NONCHAINED_OUTPUTS, cl);
            return nonChainedOutputs == null ? new ArrayList() : nonChainedOutputs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate outputs in order.", e);
        }
    }

    public void setTransitiveChainedTaskConfigs(Map<Integer, StreamConfig> chainedTaskConfigs) {
        if (chainedTaskConfigs != null) {
            chainedTaskConfigs.forEach((id, config) -> this.chainedTaskFutures.put((Integer)id, config.getSerializationFuture()));
        }
    }

    public Map<Integer, StreamConfig> getTransitiveChainedTaskConfigs(ClassLoader cl) {
        try {
            Map confs = (Map)InstantiationUtil.readObjectFromConfig(this.config, CHAINED_TASK_CONFIG, cl);
            return confs == null ? new HashMap() : confs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate configuration.", e);
        }
    }

    public Map<Integer, StreamConfig> getTransitiveChainedTaskConfigsWithSelf(ClassLoader cl) {
        Map<Integer, StreamConfig> chainedTaskConfigs = this.getTransitiveChainedTaskConfigs(cl);
        chainedTaskConfigs.put(this.getVertexID(), this);
        return chainedTaskConfigs;
    }

    public void setOperatorID(OperatorID operatorID) {
        this.config.setBytes(OPERATOR_ID, operatorID.getBytes());
    }

    public OperatorID getOperatorID() {
        byte[] operatorIDBytes = this.config.getBytes(OPERATOR_ID, null);
        return new OperatorID(Preconditions.checkNotNull(operatorIDBytes));
    }

    public void setOperatorName(String name) {
        this.config.setString(OPERATOR_NAME, name);
    }

    public String getOperatorName() {
        return this.config.getString(OPERATOR_NAME, null);
    }

    public void setChainIndex(int index) {
        this.config.setInteger(CHAIN_INDEX, index);
    }

    public int getChainIndex() {
        return this.config.getInteger(CHAIN_INDEX, 0);
    }

    public void setStateBackend(StateBackend backend) {
        if (backend != null) {
            this.toBeSerializedConfigObjects.put(STATE_BACKEND, backend);
            this.setStateBackendUsesManagedMemory(backend.useManagedMemory());
        }
    }

    public void setChangelogStateBackendEnabled(TernaryBoolean enabled) {
        this.toBeSerializedConfigObjects.put(ENABLE_CHANGE_LOG_STATE_BACKEND, (Object)enabled);
    }

    @VisibleForTesting
    public void setStateBackendUsesManagedMemory(boolean usesManagedMemory) {
        this.config.setBoolean(STATE_BACKEND_USE_MANAGED_MEMORY, usesManagedMemory);
    }

    public StateBackend getStateBackend(ClassLoader cl) {
        try {
            return (StateBackend)InstantiationUtil.readObjectFromConfig(this.config, STATE_BACKEND, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate statehandle provider.", e);
        }
    }

    public TernaryBoolean isChangelogStateBackendEnabled(ClassLoader cl) {
        try {
            return (TernaryBoolean)((Object)InstantiationUtil.readObjectFromConfig(this.config, ENABLE_CHANGE_LOG_STATE_BACKEND, cl));
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate change log state backend enable flag.", e);
        }
    }

    public void setSavepointDir(Path directory) {
        if (directory != null) {
            this.toBeSerializedConfigObjects.put(SAVEPOINT_DIR, directory);
        }
    }

    public Path getSavepointDir(ClassLoader cl) {
        try {
            return (Path)InstantiationUtil.readObjectFromConfig(this.config, SAVEPOINT_DIR, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate savepoint directory.", e);
        }
    }

    public void setCheckpointStorage(CheckpointStorage storage) {
        if (storage != null) {
            this.toBeSerializedConfigObjects.put(CHECKPOINT_STORAGE, storage);
        }
    }

    public CheckpointStorage getCheckpointStorage(ClassLoader cl) {
        try {
            return (CheckpointStorage)InstantiationUtil.readObjectFromConfig(this.config, CHECKPOINT_STORAGE, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate checkpoint storage.", e);
        }
    }

    public void setTimerServiceProvider(InternalTimeServiceManager.Provider timerServiceProvider) {
        if (timerServiceProvider != null) {
            this.toBeSerializedConfigObjects.put(TIMER_SERVICE_PROVIDER, timerServiceProvider);
        }
    }

    public InternalTimeServiceManager.Provider getTimerServiceProvider(ClassLoader cl) {
        try {
            return (InternalTimeServiceManager.Provider)InstantiationUtil.readObjectFromConfig(this.config, TIMER_SERVICE_PROVIDER, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate timer service provider.", e);
        }
    }

    public void setStatePartitioner(int input, KeySelector<?, ?> partitioner) {
        this.toBeSerializedConfigObjects.put(STATE_PARTITIONER + input, partitioner);
    }

    public <IN, K extends Serializable> KeySelector<IN, K> getStatePartitioner(int input, ClassLoader cl) {
        try {
            return (KeySelector)InstantiationUtil.readObjectFromConfig(this.config, STATE_PARTITIONER + input, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate state partitioner.", e);
        }
    }

    public void setStateKeySerializer(TypeSerializer<?> serializer) {
        this.toBeSerializedConfigObjects.put(STATE_KEY_SERIALIZER, serializer);
    }

    public <K> TypeSerializer<K> getStateKeySerializer(ClassLoader cl) {
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig(this.config, STATE_KEY_SERIALIZER, cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate state key serializer from task config.", e);
        }
    }

    public void setChainStart() {
        this.config.setBoolean(IS_CHAINED_VERTEX, true);
    }

    public boolean isChainStart() {
        return this.config.getBoolean(IS_CHAINED_VERTEX, false);
    }

    public void setChainEnd() {
        this.config.setBoolean(CHAIN_END, true);
    }

    public boolean isChainEnd() {
        return this.config.getBoolean(CHAIN_END, false);
    }

    public String toString() {
        ClassLoader cl = this.getClass().getClassLoader();
        StringBuilder builder = new StringBuilder();
        builder.append("\n=======================");
        builder.append("Stream Config");
        builder.append("=======================");
        builder.append("\nNumber of non-chained inputs: ").append(this.getNumberOfNetworkInputs());
        builder.append("\nNumber of non-chained outputs: ").append(this.getNumberOfOutputs());
        builder.append("\nOutput names: ").append(this.getOperatorNonChainedOutputs(cl));
        builder.append("\nPartitioning:");
        for (NonChainedOutput output : this.getOperatorNonChainedOutputs(cl)) {
            String outputName = output.getDataSetId().toString();
            builder.append("\n\t").append(outputName).append(": ").append(output.getPartitioner());
        }
        builder.append("\nChained subtasks: ").append(this.getChainedOutputs(cl));
        try {
            builder.append("\nOperator: ").append(this.getStreamOperatorFactory(cl).getClass().getSimpleName());
        }
        catch (Exception e) {
            builder.append("\nOperator: Missing");
        }
        builder.append("\nState Monitoring: ").append(this.isCheckpointingEnabled());
        if (this.isChainStart() && this.getChainedOutputs(cl).size() > 0) {
            builder.append("\n\n\n---------------------\nChained task configs\n---------------------\n");
            builder.append(this.getTransitiveChainedTaskConfigs(cl));
        }
        return builder.toString();
    }

    public void setGraphContainingLoops(boolean graphContainingLoops) {
        this.config.setBoolean(GRAPH_CONTAINING_LOOPS, graphContainingLoops);
    }

    public boolean isGraphContainingLoops() {
        return this.config.getBoolean(GRAPH_CONTAINING_LOOPS, false);
    }

    public static boolean requiresSorting(InputConfig inputConfig) {
        return inputConfig instanceof NetworkInputConfig && ((NetworkInputConfig)inputConfig).getInputRequirement() == InputRequirement.SORTED;
    }

    public static class SourceInputConfig
    implements InputConfig {
        private final StreamEdge inputEdge;

        public SourceInputConfig(StreamEdge inputEdge) {
            this.inputEdge = inputEdge;
        }

        public StreamEdge getInputEdge() {
            return this.inputEdge;
        }

        public String toString() {
            return this.inputEdge.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SourceInputConfig)) {
                return false;
            }
            SourceInputConfig other = (SourceInputConfig)obj;
            return Objects.equals(other.inputEdge, this.inputEdge);
        }

        public int hashCode() {
            return this.inputEdge.hashCode();
        }
    }

    public static class NetworkInputConfig
    implements InputConfig {
        private final TypeSerializer<?> typeSerializer;
        private final InputRequirement inputRequirement;
        private int inputGateIndex;

        public NetworkInputConfig(TypeSerializer<?> typeSerializer, int inputGateIndex) {
            this(typeSerializer, inputGateIndex, InputRequirement.PASS_THROUGH);
        }

        public NetworkInputConfig(TypeSerializer<?> typeSerializer, int inputGateIndex, InputRequirement inputRequirement) {
            this.typeSerializer = typeSerializer;
            this.inputGateIndex = inputGateIndex;
            this.inputRequirement = inputRequirement;
        }

        public TypeSerializer<?> getTypeSerializer() {
            return this.typeSerializer;
        }

        public int getInputGateIndex() {
            return this.inputGateIndex;
        }

        public InputRequirement getInputRequirement() {
            return this.inputRequirement;
        }
    }

    public static interface InputConfig
    extends Serializable {
    }

    public static enum InputRequirement {
        SORTED,
        PASS_THROUGH;

    }
}

