/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class DecimalModTypeStrategy
implements TypeStrategy {
    DecimalModTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType dividend = argumentDataTypes.get(0).getLogicalType();
        LogicalType divisor = argumentDataTypes.get(1).getLogicalType();
        if (dividend instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (divisor instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!StrategyUtils.isDecimalComputation(dividend, divisor)) {
            return Optional.empty();
        }
        int dividendScale = LogicalTypeChecks.getScale(dividend);
        int divisorScale = LogicalTypeChecks.getScale(divisor);
        if (dividendScale == 0 && divisorScale == 0) {
            return Optional.of(argumentDataTypes.get(1));
        }
        DecimalType decimalType = LogicalTypeMerging.findModuloDecimalType(LogicalTypeChecks.getPrecision(dividend), dividendScale, LogicalTypeChecks.getPrecision(divisor), divisorScale);
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    }
}

