/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyUnion;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyUnionObjectInspector
implements UnionObjectInspector {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazyUnionObjectInspector.class.getName());
    private List<ObjectInspector> ois;
    private byte separator;
    private LazyObjectInspectorParameters lazyParams;

    protected LazyUnionObjectInspector() {
    }

    protected LazyUnionObjectInspector(List<ObjectInspector> ois, byte separator, LazyObjectInspectorParameters lazyParams) {
        this.init(ois, separator, lazyParams);
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardUnionTypeName(this);
    }

    protected void init(List<ObjectInspector> ois, byte separator, LazyObjectInspectorParameters lazyParams) {
        this.separator = separator;
        this.lazyParams = lazyParams;
        this.ois = new ArrayList<ObjectInspector>();
        this.ois.addAll(ois);
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Text getNullSequence() {
        return this.lazyParams.getNullSequence();
    }

    public boolean isEscaped() {
        return this.lazyParams.isEscaped();
    }

    public byte getEscapeChar() {
        return this.lazyParams.getEscapeChar();
    }

    public LazyObjectInspectorParameters getLazyParams() {
        return this.lazyParams;
    }

    @Override
    public Object getField(Object data) {
        if (data == null) {
            return null;
        }
        return ((LazyUnion)data).getField();
    }

    @Override
    public List<ObjectInspector> getObjectInspectors() {
        return this.ois;
    }

    @Override
    public byte getTag(Object data) {
        if (data == null) {
            return -1;
        }
        return ((LazyUnion)data).getTag();
    }
}

