/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.compact.CompactManager;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.compact.CompactUnit;
import org.apache.flink.table.store.file.mergetree.Levels;
import org.apache.flink.table.store.file.mergetree.compact.CompactRewriter;
import org.apache.flink.table.store.file.mergetree.compact.CompactStrategy;
import org.apache.flink.table.store.file.mergetree.compact.MergeTreeCompactTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTreeCompactManager
extends CompactManager {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTreeCompactManager.class);
    private final Levels levels;
    private final CompactStrategy strategy;
    private final Comparator<RowData> keyComparator;
    private final long minFileSize;
    private final CompactRewriter rewriter;

    public MergeTreeCompactManager(ExecutorService executor, Levels levels, CompactStrategy strategy, Comparator<RowData> keyComparator, long minFileSize, CompactRewriter rewriter) {
        super(executor);
        this.levels = levels;
        this.strategy = strategy;
        this.minFileSize = minFileSize;
        this.keyComparator = keyComparator;
        this.rewriter = rewriter;
    }

    @Override
    public void submitCompaction() {
        if (this.taskFuture != null) {
            throw new IllegalStateException("Please finish the previous compaction before submitting new one.");
        }
        this.strategy.pick(this.levels.numberOfLevels(), this.levels.levelSortedRuns()).ifPresent(unit -> {
            boolean dropDelete;
            if (unit.files().size() < 2) {
                return;
            }
            boolean bl = dropDelete = unit.outputLevel() != 0 && unit.outputLevel() >= this.levels.nonEmptyHighestLevel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submit compaction with files (name, level, size): " + this.levels.levelSortedRuns().stream().flatMap(lsr -> lsr.run().files().stream()).map(file -> String.format("(%s, %d, %d)", file.fileName(), file.level(), file.fileSize())).collect(Collectors.joining(", ")));
            }
            this.submitCompaction((CompactUnit)unit, dropDelete);
        });
    }

    private void submitCompaction(CompactUnit unit, boolean dropDelete) {
        MergeTreeCompactTask task = new MergeTreeCompactTask(this.keyComparator, this.minFileSize, this.rewriter, unit, dropDelete);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pick these files (name, level, size) for compaction: {}", (Object)unit.files().stream().map(file -> String.format("(%s, %d, %d)", file.fileName(), file.level(), file.fileSize())).collect(Collectors.joining(", ")));
        }
        this.taskFuture = this.executor.submit(task);
    }

    @Override
    public Optional<CompactResult> finishCompaction(boolean blocking) throws ExecutionException, InterruptedException {
        Optional<CompactResult> result = super.finishCompaction(blocking);
        result.ifPresent(r -> this.levels.update(r.before(), r.after()));
        return result;
    }
}

