/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.lang.reflect.Array;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;

public class HeapPriorityQueueStateSnapshot<T>
implements StateSnapshot {
    @Nonnull
    private final KeyExtractorFunction<T> keyExtractor;
    @Nonnull
    private final T[] heapArrayCopy;
    @Nonnull
    private final RegisteredPriorityQueueStateBackendMetaInfo<T> metaInfo;
    @Nonnull
    private final KeyGroupRange keyGroupRange;
    @Nonnegative
    private final int totalKeyGroups;
    @Nullable
    private KeyGroupPartitioner.PartitioningResult<T> partitioningResult;

    HeapPriorityQueueStateSnapshot(@Nonnull T[] heapArrayCopy, @Nonnull KeyExtractorFunction<T> keyExtractor, @Nonnull RegisteredPriorityQueueStateBackendMetaInfo<T> metaInfo, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int totalKeyGroups) {
        this.keyExtractor = keyExtractor;
        this.heapArrayCopy = heapArrayCopy;
        this.metaInfo = metaInfo;
        this.keyGroupRange = keyGroupRange;
        this.totalKeyGroups = totalKeyGroups;
    }

    @Override
    @Nonnull
    public StateSnapshot.StateKeyGroupWriter getKeyGroupWriter() {
        return this.getPartitioningResult();
    }

    public Iterator<T> getIteratorForKeyGroup(int keyGroupId) {
        return this.getPartitioningResult().iterator(keyGroupId);
    }

    private KeyGroupPartitioner.PartitioningResult<T> getPartitioningResult() {
        if (this.partitioningResult == null) {
            Object[] partitioningOutput = (Object[])Array.newInstance(this.heapArrayCopy.getClass().getComponentType(), this.heapArrayCopy.length);
            TypeSerializer<T> elementSerializer = this.metaInfo.getElementSerializer();
            KeyGroupPartitioner<Object> keyGroupPartitioner = new KeyGroupPartitioner<Object>(this.heapArrayCopy, this.heapArrayCopy.length, partitioningOutput, this.keyGroupRange, this.totalKeyGroups, this.keyExtractor, elementSerializer::serialize);
            this.partitioningResult = keyGroupPartitioner.partitionByKeyGroup();
        }
        return this.partitioningResult;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot getMetaInfoSnapshot() {
        return this.metaInfo.snapshot();
    }

    @Nonnull
    public RegisteredPriorityQueueStateBackendMetaInfo<T> getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void release() {
    }
}

