/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.spark.SparkArrayData;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.store.utils.TypeUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkInternalRow
extends InternalRow {
    private final RowType rowType;
    private RowData row;

    public SparkInternalRow(RowType rowType) {
        this.rowType = rowType;
    }

    public SparkInternalRow replace(RowData row) {
        this.row = row;
        return this;
    }

    public int numFields() {
        return this.row.getArity();
    }

    public void setNullAt(int i) {
        throw new UnsupportedOperationException();
    }

    public void update(int i, Object value) {
        throw new UnsupportedOperationException();
    }

    public InternalRow copy() {
        return new SparkInternalRow(this.rowType).replace(RowDataUtils.copyRowData(this.row, this.rowType));
    }

    public boolean isNullAt(int ordinal) {
        return this.row.isNullAt(ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.row.getBoolean(ordinal);
    }

    public byte getByte(int ordinal) {
        return this.row.getByte(ordinal);
    }

    public short getShort(int ordinal) {
        return this.row.getShort(ordinal);
    }

    public int getInt(int ordinal) {
        return this.row.getInt(ordinal);
    }

    public long getLong(int ordinal) {
        if (this.rowType.getTypeAt(ordinal) instanceof BigIntType) {
            return this.row.getLong(ordinal);
        }
        return this.getTimestampMicros(ordinal);
    }

    private long getTimestampMicros(int ordinal) {
        LogicalType type = this.rowType.getTypeAt(ordinal);
        return SparkInternalRow.fromFlink(this.row.getTimestamp(ordinal, TypeUtils.timestampPrecision(type)));
    }

    public float getFloat(int ordinal) {
        return this.row.getFloat(ordinal);
    }

    public double getDouble(int ordinal) {
        return this.row.getDouble(ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        DecimalData decimal = this.row.getDecimal(ordinal, precision, scale);
        return SparkInternalRow.fromFlink(decimal);
    }

    public UTF8String getUTF8String(int ordinal) {
        return SparkInternalRow.fromFlink(this.row.getString(ordinal));
    }

    public byte[] getBinary(int ordinal) {
        return this.row.getBinary(ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return SparkInternalRow.fromFlink(this.row.getRow(ordinal, numFields), (RowType)this.rowType.getTypeAt(ordinal));
    }

    public org.apache.spark.sql.catalyst.util.ArrayData getArray(int ordinal) {
        return SparkInternalRow.fromFlink(this.row.getArray(ordinal), (ArrayType)this.rowType.getTypeAt(ordinal));
    }

    public org.apache.spark.sql.catalyst.util.MapData getMap(int ordinal) {
        return SparkInternalRow.fromFlink(this.row.getMap(ordinal), this.rowType.getTypeAt(ordinal));
    }

    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read((SpecializedGetters)this, (int)ordinal, (DataType)dataType, (boolean)true, (boolean)true);
    }

    public static Object fromFlink(Object o, LogicalType type) {
        if (o == null) {
            return null;
        }
        switch (type.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return SparkInternalRow.fromFlink((TimestampData)o);
            }
            case CHAR: 
            case VARCHAR: {
                return SparkInternalRow.fromFlink((StringData)o);
            }
            case DECIMAL: {
                return SparkInternalRow.fromFlink((DecimalData)o);
            }
            case ARRAY: {
                return SparkInternalRow.fromFlink((ArrayData)o, (ArrayType)type);
            }
            case MAP: 
            case MULTISET: {
                return SparkInternalRow.fromFlink((MapData)o, type);
            }
            case ROW: {
                return SparkInternalRow.fromFlink((RowData)o, (RowType)type);
            }
        }
        return o;
    }

    public static UTF8String fromFlink(StringData string) {
        return UTF8String.fromBytes((byte[])string.toBytes());
    }

    public static Decimal fromFlink(DecimalData decimal) {
        return Decimal.apply((BigDecimal)decimal.toBigDecimal());
    }

    public static InternalRow fromFlink(RowData row, RowType rowType) {
        return new SparkInternalRow(rowType).replace(row);
    }

    public static long fromFlink(TimestampData timestamp) {
        return DateTimeUtils.fromJavaTimestamp((Timestamp)timestamp.toTimestamp());
    }

    public static org.apache.spark.sql.catalyst.util.ArrayData fromFlink(ArrayData array, ArrayType arrayType) {
        return SparkInternalRow.fromFlinkArrayElementType(array, arrayType.getElementType());
    }

    private static org.apache.spark.sql.catalyst.util.ArrayData fromFlinkArrayElementType(ArrayData array, LogicalType elementType) {
        return new SparkArrayData(elementType).replace(array);
    }

    public static org.apache.spark.sql.catalyst.util.MapData fromFlink(MapData map, LogicalType mapType) {
        LogicalType valueType;
        LogicalType keyType;
        if (mapType instanceof MapType) {
            keyType = ((MapType)mapType).getKeyType();
            valueType = ((MapType)mapType).getValueType();
        } else if (mapType instanceof MultisetType) {
            keyType = ((MultisetType)mapType).getElementType();
            valueType = new IntType();
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + mapType);
        }
        return new ArrayBasedMapData(SparkInternalRow.fromFlinkArrayElementType(map.keyArray(), keyType), SparkInternalRow.fromFlinkArrayElementType(map.valueArray(), valueType));
    }
}

