/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.throwable;

import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.ExceptionUtils;

@Internal
public class FatalExceptionClassifier {
    private final Function<Throwable, Exception> throwableMapper;
    private final Predicate<Throwable> validator;
    private FatalExceptionClassifier chainedClassifier;

    public FatalExceptionClassifier(Predicate<Throwable> validator, Function<Throwable, Exception> throwableMapper) {
        this.throwableMapper = throwableMapper;
        this.validator = validator;
        this.chainedClassifier = null;
    }

    public boolean isFatal(Throwable err, Consumer<Exception> throwableConsumer) {
        if (this.validator.test(err)) {
            throwableConsumer.accept(this.throwableMapper.apply(err));
            return false;
        }
        if (this.chainedClassifier != null) {
            return this.chainedClassifier.isFatal(err, throwableConsumer);
        }
        return true;
    }

    public static FatalExceptionClassifier withRootCauseOfType(Class<? extends Throwable> type, Function<Throwable, Exception> mapper) {
        return new FatalExceptionClassifier(err -> ExceptionUtils.findThrowable(err, type).isPresent(), mapper);
    }

    public static FatalExceptionClassifier createChain(FatalExceptionClassifier ... classifiers) {
        HashSet<FatalExceptionClassifier> importedClassifiers = new HashSet<FatalExceptionClassifier>();
        if (classifiers.length == 0) {
            throw new IllegalArgumentException("Cannot create empty classifier chain.");
        }
        FatalExceptionClassifier tailClassifier = classifiers[0];
        importedClassifiers.add(tailClassifier);
        for (int i = 1; i < classifiers.length; ++i) {
            if (importedClassifiers.contains(classifiers[i])) {
                throw new IllegalArgumentException("Wrong classifier chain; Circular chain of classifiers detected.");
            }
            tailClassifier.chainedClassifier = classifiers[i];
            tailClassifier = classifiers[i];
            importedClassifiers.add(tailClassifier);
        }
        return classifiers[0];
    }
}

