/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.manifest.ManifestCommittable;
import org.apache.flink.table.store.file.operation.FileStoreCommit;
import org.apache.flink.table.store.file.operation.FileStoreExpire;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.table.sink.FileCommittable;

public class TableCommit
implements AutoCloseable {
    private final FileStoreCommit commit;
    private final FileStoreExpire expire;
    @Nullable
    private Map<String, String> overwritePartition = null;
    @Nullable
    private Lock lock;

    public TableCommit(FileStoreCommit commit, FileStoreExpire expire) {
        this.commit = commit;
        this.expire = expire;
    }

    public TableCommit withOverwritePartition(@Nullable Map<String, String> overwritePartition) {
        this.overwritePartition = overwritePartition;
        return this;
    }

    public TableCommit withLock(Lock lock) {
        this.commit.withLock(lock);
        this.expire.withLock(lock);
        this.lock = lock;
        return this;
    }

    public TableCommit withCreateEmptyCommit(boolean createEmptyCommit) {
        this.commit.withCreateEmptyCommit(createEmptyCommit);
        return this;
    }

    public List<ManifestCommittable> filterCommitted(List<ManifestCommittable> committables) {
        return this.commit.filterCommitted(committables);
    }

    public void commit(String identifier, List<FileCommittable> fileCommittables) {
        ManifestCommittable committable = new ManifestCommittable(identifier);
        for (FileCommittable fileCommittable : fileCommittables) {
            committable.addFileCommittable(fileCommittable.partition(), fileCommittable.bucket(), fileCommittable.increment());
        }
        this.commit(Collections.singletonList(committable));
    }

    public void commit(List<ManifestCommittable> committables) {
        if (this.overwritePartition == null) {
            for (ManifestCommittable committable : committables) {
                this.commit.commit(committable, new HashMap<String, String>());
            }
        } else {
            for (ManifestCommittable committable : committables) {
                this.commit.overwrite(this.overwritePartition, committable, new HashMap<String, String>());
            }
        }
        this.expire.expire();
    }

    @Override
    public void close() throws Exception {
        if (this.lock != null) {
            this.lock.close();
        }
    }
}

