/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.memory;

import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.table.store.file.memory.MemoryOwner;

public class MemoryPoolFactory {
    private final MemorySegmentPool innerPool;
    private final Iterable<MemoryOwner> owners;

    public MemoryPoolFactory(MemorySegmentPool innerPool, Iterable<MemoryOwner> owners) {
        this.innerPool = innerPool;
        this.owners = owners;
    }

    public void notifyNewOwner(MemoryOwner owner) {
        OwnerMemoryPool memoryPool = new OwnerMemoryPool(owner);
        owner.setMemoryPool(memoryPool);
    }

    private void preemptMemory(MemoryOwner owner) {
        long maxMemory = -1L;
        MemoryOwner max = null;
        for (MemoryOwner other : this.owners) {
            if (other == owner || other.memoryOccupancy() <= maxMemory) continue;
            maxMemory = other.memoryOccupancy();
            max = other;
        }
        if (max != null) {
            try {
                max.flushMemory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class OwnerMemoryPool
    implements MemorySegmentPool {
        private final MemoryOwner owner;

        public OwnerMemoryPool(MemoryOwner owner) {
            this.owner = owner;
        }

        @Override
        public int pageSize() {
            return MemoryPoolFactory.this.innerPool.pageSize();
        }

        @Override
        public void returnAll(List<MemorySegment> memory) {
            MemoryPoolFactory.this.innerPool.returnAll(memory);
        }

        @Override
        public int freePages() {
            return MemoryPoolFactory.this.innerPool.freePages();
        }

        @Override
        public MemorySegment nextSegment() {
            MemorySegment segment = MemoryPoolFactory.this.innerPool.nextSegment();
            if (segment == null) {
                MemoryPoolFactory.this.preemptMemory(this.owner);
                return MemoryPoolFactory.this.innerPool.nextSegment();
            }
            return segment;
        }
    }
}

