/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.util.Shell;

public class ProxyLocalFileSystem
extends FilterFileSystem {
    protected LocalFileSystem localFs;

    public ProxyLocalFileSystem() {
        this.localFs = new LocalFileSystem();
    }

    public ProxyLocalFileSystem(FileSystem fs) {
        throw new RuntimeException("Unsupported Constructor");
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        String scheme = name.getScheme();
        String nameUriString = name.toString();
        if (Shell.WINDOWS) {
            nameUriString = nameUriString.replaceAll("%5C", "/").replaceFirst("/[c-zC-Z]:", "/").replaceFirst("^[c-zC-Z]:", "");
            name = URI.create(nameUriString);
        }
        String authority = name.getAuthority() != null ? name.getAuthority() : "";
        String proxyUriString = nameUriString + "://" + authority + "/";
        this.fs = ShimLoader.getHadoopShims().createProxyFileSystem((FileSystem)this.localFs, URI.create(proxyUriString));
        this.fs.initialize(name, conf);
    }
}

