/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;

public class PartialUpdateMergeFunction
implements MergeFunction {
    private static final long serialVersionUID = 1L;
    private final RowData.FieldGetter[] getters;
    private transient GenericRowData row;

    public PartialUpdateMergeFunction(RowData.FieldGetter[] getters) {
        this.getters = getters;
    }

    @Override
    public void reset() {
        this.row = new GenericRowData(this.getters.length);
    }

    @Override
    public void add(RowData value) {
        for (int i = 0; i < this.getters.length; ++i) {
            Object field = this.getters[i].getFieldOrNull(value);
            if (field == null) continue;
            this.row.setField(i, field);
        }
    }

    @Override
    @Nullable
    public RowData getValue() {
        return this.row;
    }

    @Override
    public MergeFunction copy() {
        return new PartialUpdateMergeFunction(this.getters);
    }
}

