/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.IOException;
import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.sink.Committable;

public abstract class PrepareCommitOperator
extends AbstractStreamOperator<Committable>
implements OneInputStreamOperator<RowData, Committable>,
BoundedOneInput {
    private boolean endOfInput = false;

    public PrepareCommitOperator() {
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        if (!this.endOfInput) {
            this.emitCommittables(false);
        }
    }

    public void endInput() throws Exception {
        this.endOfInput = true;
        this.emitCommittables(true);
    }

    private void emitCommittables(boolean endOfInput) throws IOException {
        this.prepareCommit(endOfInput).forEach(committable -> this.output.collect((Object)new StreamRecord(committable)));
    }

    protected abstract List<Committable> prepareCommit(boolean var1) throws IOException;
}

