/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.file.predicate.And;
import org.apache.flink.table.store.file.predicate.CompoundPredicate;
import org.apache.flink.table.store.file.predicate.Equal;
import org.apache.flink.table.store.file.predicate.GreaterOrEqual;
import org.apache.flink.table.store.file.predicate.GreaterThan;
import org.apache.flink.table.store.file.predicate.In;
import org.apache.flink.table.store.file.predicate.IsNotNull;
import org.apache.flink.table.store.file.predicate.IsNull;
import org.apache.flink.table.store.file.predicate.LeafPredicate;
import org.apache.flink.table.store.file.predicate.LeafUnaryFunction;
import org.apache.flink.table.store.file.predicate.LessOrEqual;
import org.apache.flink.table.store.file.predicate.LessThan;
import org.apache.flink.table.store.file.predicate.NotEqual;
import org.apache.flink.table.store.file.predicate.NullFalseLeafBinaryFunction;
import org.apache.flink.table.store.file.predicate.Or;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.StartsWith;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class PredicateBuilder {
    private final RowType rowType;

    public PredicateBuilder(RowType rowType) {
        this.rowType = rowType;
    }

    public Predicate equal(int idx, Object literal) {
        return this.leaf(Equal.INSTANCE, idx, literal);
    }

    public Predicate notEqual(int idx, Object literal) {
        return this.leaf(NotEqual.INSTANCE, idx, literal);
    }

    public Predicate lessThan(int idx, Object literal) {
        return this.leaf(LessThan.INSTANCE, idx, literal);
    }

    public Predicate lessOrEqual(int idx, Object literal) {
        return this.leaf(LessOrEqual.INSTANCE, idx, literal);
    }

    public Predicate greaterThan(int idx, Object literal) {
        return this.leaf(GreaterThan.INSTANCE, idx, literal);
    }

    public Predicate greaterOrEqual(int idx, Object literal) {
        return this.leaf(GreaterOrEqual.INSTANCE, idx, literal);
    }

    public Predicate isNull(int idx) {
        return this.leaf(IsNull.INSTANCE, idx);
    }

    public Predicate isNotNull(int idx) {
        return this.leaf(IsNotNull.INSTANCE, idx);
    }

    public Predicate startsWith(int idx, Object patternLiteral) {
        return this.leaf(StartsWith.INSTANCE, idx, patternLiteral);
    }

    public Predicate leaf(NullFalseLeafBinaryFunction function, int idx, Object literal) {
        RowType.RowField field = (RowType.RowField)this.rowType.getFields().get(idx);
        return new LeafPredicate(function, field.getType(), idx, field.getName(), Collections.singletonList(literal));
    }

    public Predicate leaf(LeafUnaryFunction function, int idx) {
        RowType.RowField field = (RowType.RowField)this.rowType.getFields().get(idx);
        return new LeafPredicate(function, field.getType(), idx, field.getName(), Collections.emptyList());
    }

    public Predicate in(int idx, List<Object> literals) {
        if (literals.size() > 20) {
            RowType.RowField field = (RowType.RowField)this.rowType.getFields().get(idx);
            return new LeafPredicate(In.INSTANCE, field.getType(), idx, field.getName(), literals);
        }
        ArrayList<Predicate> equals = new ArrayList<Predicate>(literals.size());
        for (Object literal : literals) {
            equals.add(this.equal(idx, literal));
        }
        return PredicateBuilder.or(equals);
    }

    public Predicate notIn(int idx, List<Object> literals) {
        return this.in(idx, literals).negate().get();
    }

    public Predicate between(int idx, Object includedLowerBound, Object includedUpperBound) {
        return new CompoundPredicate(And.INSTANCE, Arrays.asList(this.greaterOrEqual(idx, includedLowerBound), this.lessOrEqual(idx, includedUpperBound)));
    }

    public static Predicate and(Predicate ... predicates) {
        return PredicateBuilder.and(Arrays.asList(predicates));
    }

    public static Predicate and(List<Predicate> predicates) {
        Preconditions.checkArgument((predicates.size() > 0 ? 1 : 0) != 0, (Object)"There must be at least 1 inner predicate to construct an AND predicate");
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        return (Predicate)predicates.stream().reduce((a, b) -> new CompoundPredicate(And.INSTANCE, Arrays.asList(a, b))).get();
    }

    public static Predicate or(Predicate ... predicates) {
        return PredicateBuilder.or(Arrays.asList(predicates));
    }

    public static Predicate or(List<Predicate> predicates) {
        Preconditions.checkArgument((predicates.size() > 0 ? 1 : 0) != 0, (Object)"There must be at least 1 inner predicate to construct an OR predicate");
        return (Predicate)predicates.stream().reduce((a, b) -> new CompoundPredicate(Or.INSTANCE, Arrays.asList(a, b))).get();
    }

    public static List<Predicate> splitAnd(@Nullable Predicate predicate) {
        if (predicate == null) {
            return Collections.emptyList();
        }
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        PredicateBuilder.splitCompound(And.INSTANCE, predicate, result);
        return result;
    }

    public static List<Predicate> splitOr(@Nullable Predicate predicate) {
        if (predicate == null) {
            return Collections.emptyList();
        }
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        PredicateBuilder.splitCompound(Or.INSTANCE, predicate, result);
        return result;
    }

    private static void splitCompound(CompoundPredicate.Function function, Predicate predicate, List<Predicate> result) {
        if (predicate instanceof CompoundPredicate && ((CompoundPredicate)predicate).function().equals(function)) {
            for (Predicate child : ((CompoundPredicate)predicate).children()) {
                PredicateBuilder.splitCompound(function, child, result);
            }
        } else {
            result.add(predicate);
        }
    }

    public static Object convertJavaObject(LogicalType literalType, Object o) {
        if (o == null) {
            return null;
        }
        switch (literalType.getTypeRoot()) {
            case BOOLEAN: {
                return o;
            }
            case BIGINT: {
                return ((Number)o).longValue();
            }
            case DOUBLE: {
                return ((Number)o).doubleValue();
            }
            case TINYINT: {
                return ((Number)o).byteValue();
            }
            case SMALLINT: {
                return ((Number)o).shortValue();
            }
            case INTEGER: {
                return ((Number)o).intValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)o).floatValue());
            }
            case VARCHAR: {
                return StringData.fromString((String)o.toString());
            }
            case DATE: {
                LocalDate localDate;
                if (o instanceof Timestamp) {
                    localDate = ((Timestamp)o).toLocalDateTime().toLocalDate();
                } else if (o instanceof Date) {
                    localDate = ((Date)o).toLocalDate();
                } else if (o instanceof LocalDate) {
                    localDate = (LocalDate)o;
                } else {
                    throw new UnsupportedOperationException("Unexpected date literal of class " + o.getClass().getName());
                }
                LocalDate epochDay = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC).toLocalDate();
                return (int)ChronoUnit.DAYS.between(epochDay, localDate);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)literalType;
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                return DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)o), (int)precision, (int)scale);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                TimestampData timestampData;
                if (o instanceof Timestamp) {
                    timestampData = TimestampData.fromTimestamp((Timestamp)((Timestamp)o));
                } else if (o instanceof Instant) {
                    timestampData = TimestampData.fromInstant((Instant)((Instant)o));
                } else if (o instanceof LocalDateTime) {
                    timestampData = TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)o));
                } else {
                    throw new UnsupportedOperationException("Unsupported object: " + o);
                }
                return timestampData;
            }
        }
        throw new UnsupportedOperationException("Unsupported predicate leaf type " + literalType.getTypeRoot().name());
    }

    public static List<Predicate> pickTransformFieldMapping(List<Predicate> predicates, List<String> inputFields, List<String> pickedFields) {
        return PredicateBuilder.pickTransformFieldMapping(predicates, inputFields.stream().mapToInt(pickedFields::indexOf).toArray());
    }

    public static List<Predicate> pickTransformFieldMapping(List<Predicate> predicates, int[] fieldIdxMapping) {
        ArrayList<Predicate> pick = new ArrayList<Predicate>();
        for (Predicate p : predicates) {
            Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(p, fieldIdxMapping);
            mapped.ifPresent(pick::add);
        }
        return pick;
    }

    public static Optional<Predicate> transformFieldMapping(Predicate predicate, int[] fieldIdxMapping) {
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            ArrayList<Predicate> children = new ArrayList<Predicate>();
            for (Predicate child : compoundPredicate.children()) {
                Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(child, fieldIdxMapping);
                if (mapped.isPresent()) {
                    children.add(mapped.get());
                    continue;
                }
                return Optional.empty();
            }
            return Optional.of(new CompoundPredicate(compoundPredicate.function(), children));
        }
        LeafPredicate leafPredicate = (LeafPredicate)predicate;
        int mapped = fieldIdxMapping[leafPredicate.index()];
        if (mapped >= 0) {
            return Optional.of(new LeafPredicate(leafPredicate.function(), leafPredicate.type(), mapped, leafPredicate.fieldName(), leafPredicate.literals()));
        }
        return Optional.empty();
    }

    public static boolean containsFields(Predicate predicate, Set<String> fields) {
        if (predicate instanceof CompoundPredicate) {
            for (Predicate child : ((CompoundPredicate)predicate).children()) {
                if (!PredicateBuilder.containsFields(child, fields)) continue;
                return true;
            }
            return false;
        }
        LeafPredicate leafPredicate = (LeafPredicate)predicate;
        return fields.contains(leafPredicate.fieldName());
    }
}

