/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.source.ContinuousFileSplitEnumerator;
import org.apache.flink.table.store.connector.source.FileStoreSourceReader;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitGenerator;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplitSerializer;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpoint;
import org.apache.flink.table.store.connector.source.PendingSplitsCheckpointSerializer;
import org.apache.flink.table.store.connector.source.StaticFileStoreSplitEnumerator;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.TableScan;
import org.apache.flink.util.Preconditions;

public class FileStoreSource
implements Source<RowData, FileStoreSourceSplit, PendingSplitsCheckpoint> {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable table;
    private final boolean isContinuous;
    private final long discoveryInterval;
    private final boolean latestContinuous;
    @Nullable
    private final int[][] projectedFields;
    @Nullable
    private final Predicate predicate;

    public FileStoreSource(FileStoreTable table, boolean isContinuous, long discoveryInterval, boolean latestContinuous, @Nullable int[][] projectedFields, @Nullable Predicate predicate) {
        this.table = table;
        this.isContinuous = isContinuous;
        this.discoveryInterval = discoveryInterval;
        this.latestContinuous = latestContinuous;
        this.projectedFields = projectedFields;
        this.predicate = predicate;
    }

    public Boundedness getBoundedness() {
        return this.isContinuous ? Boundedness.CONTINUOUS_UNBOUNDED : Boundedness.BOUNDED;
    }

    public SourceReader<RowData, FileStoreSourceSplit> createReader(SourceReaderContext context) {
        TableRead read = this.table.newRead();
        if (this.projectedFields != null) {
            read.withProjection(this.projectedFields);
        }
        if (this.predicate != null) {
            read.withFilter(this.predicate);
        }
        return new FileStoreSourceReader(context, read);
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> createEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context) {
        return this.restoreEnumerator(context, null);
    }

    public SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> restoreEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, PendingSplitsCheckpoint checkpoint) {
        Collection<FileStoreSourceSplit> splits;
        Long snapshotId;
        SnapshotManager snapshotManager = this.table.snapshotManager();
        TableScan scan = this.table.newScan();
        if (this.predicate != null) {
            scan.withFilter(this.predicate);
        }
        if (checkpoint == null) {
            if (this.latestContinuous) {
                Preconditions.checkArgument((boolean)this.isContinuous, (Object)"The latest continuous can only be true when isContinuous is true.");
                snapshotId = snapshotManager.latestSnapshotId();
                splits = new ArrayList<FileStoreSourceSplit>();
            } else {
                TableScan.Plan plan = scan.plan();
                snapshotId = plan.snapshotId;
                splits = new FileStoreSourceSplitGenerator().createSplits(plan);
            }
        } else {
            snapshotId = checkpoint.currentSnapshotId();
            if (snapshotId == -1L) {
                snapshotId = null;
            }
            splits = checkpoint.splits();
        }
        if (this.isContinuous) {
            long currentSnapshot = snapshotId == null ? 0L : snapshotId;
            return new ContinuousFileSplitEnumerator(context, scan.withIncremental(true), snapshotManager, splits, currentSnapshot, this.discoveryInterval);
        }
        Snapshot snapshot = snapshotId == null ? null : snapshotManager.snapshot(snapshotId);
        return new StaticFileStoreSplitEnumerator(context, snapshot, splits);
    }

    public FileStoreSourceSplitSerializer getSplitSerializer() {
        return new FileStoreSourceSplitSerializer();
    }

    public PendingSplitsCheckpointSerializer getEnumeratorCheckpointSerializer() {
        return new PendingSplitsCheckpointSerializer(this.getSplitSerializer());
    }
}

