/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.store.connector.sink.Committable;
import org.apache.flink.table.store.connector.sink.FileCommittableSerializer;
import org.apache.flink.table.store.connector.sink.LogOffsetCommittable;
import org.apache.flink.table.store.table.sink.FileCommittable;

public class CommittableSerializer
implements SimpleVersionedSerializer<Committable> {
    private final FileCommittableSerializer fileCommittableSerializer;

    public CommittableSerializer(FileCommittableSerializer fileCommittableSerializer) {
        this.fileCommittableSerializer = fileCommittableSerializer;
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(Committable committable) throws IOException {
        byte[] wrapped;
        int version;
        switch (committable.kind()) {
            case FILE: {
                version = this.fileCommittableSerializer.getVersion();
                wrapped = this.fileCommittableSerializer.serialize((FileCommittable)committable.wrappedCommittable());
                break;
            }
            case LOG_OFFSET: {
                version = 1;
                wrapped = ((LogOffsetCommittable)committable.wrappedCommittable()).toBytes();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported kind: " + (Object)((Object)committable.kind()));
            }
        }
        return ByteBuffer.allocate(1 + wrapped.length + 4).put(committable.kind().toByteValue()).put(wrapped).putInt(version).array();
    }

    public Committable deserialize(int i, byte[] bytes) throws IOException {
        Object wrappedCommittable;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        Committable.Kind kind = Committable.Kind.fromByteValue(buffer.get());
        byte[] wrapped = new byte[bytes.length - 5];
        buffer.get(wrapped);
        int version = buffer.getInt();
        switch (kind) {
            case FILE: {
                wrappedCommittable = this.fileCommittableSerializer.deserialize(version, wrapped);
                break;
            }
            case LOG_OFFSET: {
                wrappedCommittable = LogOffsetCommittable.fromBytes(wrapped);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported kind: " + (Object)((Object)kind));
            }
        }
        return new Committable(kind, wrappedCommittable);
    }
}

