/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.connector.FlinkConnectorOptions;
import org.apache.flink.table.store.connector.sink.TableStoreSink;
import org.apache.flink.table.store.connector.source.TableStoreSource;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.log.LogStoreTableFactory;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.FileStoreTableFactory;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class AbstractTableStoreFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        return new TableStoreSource(context.getObjectIdentifier(), AbstractTableStoreFactory.buildFileStoreTable(context), context.getConfiguration().get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING, context, AbstractTableStoreFactory.createOptionalLogStoreFactory(context).orElse(null));
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        return new TableStoreSink(context.getObjectIdentifier(), AbstractTableStoreFactory.buildFileStoreTable(context), context, AbstractTableStoreFactory.createOptionalLogStoreFactory(context).orElse(null));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.addAll(FlinkConnectorOptions.getOptions());
        options.addAll(CoreOptions.getOptions());
        return options;
    }

    static Optional<LogStoreTableFactory> createOptionalLogStoreFactory(DynamicTableFactory.Context context) {
        return AbstractTableStoreFactory.createOptionalLogStoreFactory(context.getClassLoader(), context.getCatalogTable().getOptions());
    }

    static Optional<LogStoreTableFactory> createOptionalLogStoreFactory(ClassLoader classLoader, Map<String, String> options) {
        Configuration configOptions = new Configuration();
        options.forEach((arg_0, arg_1) -> ((Configuration)configOptions).setString(arg_0, arg_1));
        if (configOptions.get(FlinkConnectorOptions.LOG_SYSTEM) == null) {
            AbstractTableStoreFactory.validateFileStoreContinuous(configOptions);
            return Optional.empty();
        }
        return Optional.of(LogStoreTableFactory.discoverLogStoreFactory(classLoader, (String)configOptions.get(FlinkConnectorOptions.LOG_SYSTEM)));
    }

    private static void validateFileStoreContinuous(Configuration options) {
        CoreOptions.LogChangelogMode changelogMode = (CoreOptions.LogChangelogMode)((Object)options.get(CoreOptions.LOG_CHANGELOG_MODE));
        if (changelogMode == CoreOptions.LogChangelogMode.UPSERT) {
            throw new ValidationException("File store continuous reading dose not support upsert changelog mode.");
        }
        CoreOptions.LogConsistency consistency = (CoreOptions.LogConsistency)((Object)options.get(CoreOptions.LOG_CONSISTENCY));
        if (consistency == CoreOptions.LogConsistency.EVENTUAL) {
            throw new ValidationException("File store continuous reading dose not support eventual consistency mode.");
        }
        CoreOptions.LogStartupMode startupMode = (CoreOptions.LogStartupMode)((Object)options.get(CoreOptions.LOG_SCAN));
        if (startupMode == CoreOptions.LogStartupMode.FROM_TIMESTAMP) {
            throw new ValidationException("File store continuous reading dose not support from_timestamp scan mode, you can add timestamp filters instead.");
        }
    }

    static FileStoreTable buildFileStoreTable(DynamicTableFactory.Context context) {
        FileStoreTable table = FileStoreTableFactory.create(Configuration.fromMap((Map)context.getCatalogTable().getOptions()));
        TableSchema tableSchema = table.schema();
        UpdateSchema updateSchema = UpdateSchema.fromCatalogTable((CatalogTable)context.getCatalogTable());
        RowType rowType = updateSchema.rowType();
        List<String> partitionKeys = updateSchema.partitionKeys();
        List<String> primaryKeys = updateSchema.primaryKeys();
        Preconditions.checkArgument((boolean)AbstractTableStoreFactory.schemaEquals(tableSchema.logicalRowType(), rowType), (String)"Flink schema and store schema are not the same, store schema is %s, Flink schema is %s", (Object[])new Object[]{tableSchema.logicalRowType(), rowType});
        Preconditions.checkArgument((boolean)tableSchema.partitionKeys().equals(partitionKeys), (String)"Flink partitionKeys and store partitionKeys are not the same, store partitionKeys is %s, Flink partitionKeys is %s", (Object[])new Object[]{tableSchema.partitionKeys(), partitionKeys});
        Preconditions.checkArgument((boolean)tableSchema.primaryKeys().equals(primaryKeys), (String)"Flink primaryKeys and store primaryKeys are not the same, store primaryKeys is %s, Flink primaryKeys is %s", (Object[])new Object[]{tableSchema.primaryKeys(), primaryKeys});
        return table;
    }

    @VisibleForTesting
    static boolean schemaEquals(RowType rowType1, RowType rowType2) {
        List fieldList1 = rowType1.getFields();
        List fieldList2 = rowType2.getFields();
        if (fieldList1.size() != fieldList2.size()) {
            return false;
        }
        for (int i = 0; i < fieldList1.size(); ++i) {
            RowType.RowField f1 = (RowType.RowField)fieldList1.get(i);
            RowType.RowField f2 = (RowType.RowField)fieldList2.get(i);
            if (f1.getName().equals(f2.getName()) && f1.getType().equals((Object)f2.getType())) continue;
            return false;
        }
        return true;
    }
}

