/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.param;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.param.Param;

@PublicEvolving
public interface WithParams<T> {
    default public <V> Param<V> getParam(String name) {
        Optional<Param> result = this.getParamMap().keySet().stream().filter(param -> param.name.equals(name)).findAny();
        return result.orElse(null);
    }

    default public <V> T set(Param<V> param, V value) {
        if (!this.getParamMap().containsKey(param)) {
            throw new IllegalArgumentException("Parameter " + param.name + " is not defined on the class " + this.getClass().getName());
        }
        if (value != null && !param.clazz.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Parameter " + param.name + " is given a value with incompatible class " + value.getClass().getName());
        }
        if (!param.validator.validate(value)) {
            if (value == null) {
                throw new IllegalArgumentException("Parameter " + param.name + "'s value should not be null");
            }
            throw new IllegalArgumentException("Parameter " + param.name + " is given an invalid value " + (value.getClass().isArray() ? ArrayUtils.toString(value) : value));
        }
        this.getParamMap().put(param, value);
        return (T)this;
    }

    default public <V> V get(Param<V> param) {
        Map<Param<?>, Object> paramMap = this.getParamMap();
        Object value = paramMap.get(param);
        if (value == null && !param.validator.validate(value)) {
            throw new IllegalArgumentException("Parameter " + param.name + "'s value should not be null");
        }
        return (V)value;
    }

    public Map<Param<?>, Object> getParamMap();
}

