/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.proxy.state;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.flink.iteration.proxy.state.ProxyInternalTimeServiceManager;
import org.apache.flink.iteration.proxy.state.ProxyKeyedStateBackend;
import org.apache.flink.iteration.proxy.state.ProxyOperatorStateBackend;
import org.apache.flink.iteration.proxy.state.StateNamePrefix;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupStatePartitionStreamProvider;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.StreamOperatorStateContext;
import org.apache.flink.util.CloseableIterable;

public class ProxyStreamOperatorStateContext
implements StreamOperatorStateContext {
    private final StreamOperatorStateContext wrapped;
    private final StateNamePrefix stateNamePrefix;
    private final Iterator<StatePartitionStreamProvider> rawOperatorStates;
    private final int numberOfRawOperatorStateEntries;

    public ProxyStreamOperatorStateContext(StreamOperatorStateContext wrapped, String stateNamePrefix, Iterator<StatePartitionStreamProvider> rawOperatorStates, int numberOfRawOperatorStateEntries) {
        this.wrapped = Objects.requireNonNull(wrapped);
        this.stateNamePrefix = new StateNamePrefix(stateNamePrefix);
        this.rawOperatorStates = Objects.requireNonNull(rawOperatorStates);
        this.numberOfRawOperatorStateEntries = numberOfRawOperatorStateEntries;
    }

    public boolean isRestored() {
        return this.wrapped.isRestored();
    }

    public OptionalLong getRestoredCheckpointId() {
        return this.wrapped.getRestoredCheckpointId();
    }

    public OperatorStateBackend operatorStateBackend() {
        return this.wrapped.operatorStateBackend() == null ? null : new ProxyOperatorStateBackend(this.wrapped.operatorStateBackend(), this.stateNamePrefix);
    }

    public CheckpointableKeyedStateBackend<?> keyedStateBackend() {
        return this.wrapped.keyedStateBackend() == null ? null : new ProxyKeyedStateBackend(this.wrapped.keyedStateBackend(), this.stateNamePrefix);
    }

    public InternalTimeServiceManager<?> internalTimerServiceManager() {
        return this.wrapped.internalTimerServiceManager() == null ? null : new ProxyInternalTimeServiceManager(this.wrapped.internalTimerServiceManager(), this.stateNamePrefix);
    }

    public CloseableIterable<StatePartitionStreamProvider> rawOperatorStateInputs() {
        return new RawOperatorStateIterable();
    }

    public CloseableIterable<KeyGroupStatePartitionStreamProvider> rawKeyedStateInputs() {
        return CloseableIterable.empty();
    }

    private class RawOperatorStateIterable
    implements CloseableIterable<StatePartitionStreamProvider> {
        private int remaining;

        public RawOperatorStateIterable() {
            this.remaining = ProxyStreamOperatorStateContext.this.numberOfRawOperatorStateEntries;
        }

        public Iterator<StatePartitionStreamProvider> iterator() {
            return new Iterator<StatePartitionStreamProvider>(){

                @Override
                public boolean hasNext() {
                    return RawOperatorStateIterable.this.remaining > 0;
                }

                @Override
                public StatePartitionStreamProvider next() {
                    RawOperatorStateIterable.this.remaining--;
                    return (StatePartitionStreamProvider)ProxyStreamOperatorStateContext.this.rawOperatorStates.next();
                }
            };
        }

        public void close() throws IOException {
        }
    }
}

