/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration;

import java.util.Objects;

public class IterationRecord<T>
implements Cloneable {
    private Type type;
    private int epoch;
    private T value;
    private String sender;
    private long checkpointId;

    public static <T> IterationRecord<T> newRecord(T value, int epoch) {
        return new IterationRecord<T>(Type.RECORD, epoch, value, null, 0L);
    }

    public static <T> IterationRecord<T> newEpochWatermark(int epoch, String sender) {
        return new IterationRecord<Object>(Type.EPOCH_WATERMARK, epoch, null, sender, 0L);
    }

    public static <T> IterationRecord<T> newBarrier(long checkpointId) {
        return new IterationRecord<Object>(Type.BARRIER, 0, null, null, checkpointId);
    }

    private IterationRecord(Type type, int epoch, T value, String sender, long checkpointId) {
        this.type = type;
        this.epoch = epoch;
        this.value = value;
        this.sender = sender;
        this.checkpointId = checkpointId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public void incrementEpoch() {
        ++this.epoch;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public void setCheckpointId(long checkpointId) {
        this.checkpointId = checkpointId;
    }

    public IterationRecord<T> clone() {
        switch (this.type) {
            case RECORD: {
                return IterationRecord.newRecord(this.value, this.epoch);
            }
            case EPOCH_WATERMARK: {
                return IterationRecord.newEpochWatermark(this.epoch, this.sender);
            }
            case BARRIER: {
                return IterationRecord.newBarrier(this.checkpointId);
            }
        }
        throw new RuntimeException("Unsupported type: " + (Object)((Object)this.type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationRecord that = (IterationRecord)o;
        return this.epoch == that.epoch && this.type == that.type && Objects.equals(this.value, that.value) && Objects.equals(this.sender, that.sender) && this.checkpointId == that.checkpointId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.epoch, this.value, this.sender, this.checkpointId});
    }

    public String toString() {
        return "IterationRecord{type=" + (Object)((Object)this.type) + ", epoch=" + this.epoch + ", value=" + this.value + ", sender='" + this.sender + "', checkpointId=" + this.checkpointId + "}";
    }

    public static enum Type {
        RECORD,
        EPOCH_WATERMARK,
        BARRIER;

    }
}

