/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.types;

import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufTypeInformation;
import org.apache.flink.statefun.flink.core.types.StaticallyRegisteredTypes;

@NotThreadSafe
public final class DynamicallyRegisteredTypes {
    private final StaticallyRegisteredTypes staticallyKnownTypes;
    private final Map<Class<?>, TypeInformation<?>> registeredTypes = new HashMap();

    public DynamicallyRegisteredTypes(StaticallyRegisteredTypes staticallyKnownTypes) {
        this.staticallyKnownTypes = Objects.requireNonNull(staticallyKnownTypes);
    }

    public <T> TypeInformation<T> registerType(Class<T> type) {
        TypeInformation<T> typeInfo = this.staticallyKnownTypes.getType(type);
        if (typeInfo != null) {
            return typeInfo;
        }
        return this.registeredTypes.computeIfAbsent(type, this::typeInformation);
    }

    private TypeInformation<?> typeInformation(Class<?> valueType) {
        if (Message.class.isAssignableFrom(valueType)) {
            Class<?> message = valueType;
            return new ProtobufTypeInformation(message);
        }
        return TypeInformation.of(valueType);
    }
}

