/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.net.URI;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.statefun.flink.core.common.ManagingResources;
import org.apache.flink.statefun.flink.core.httpfn.HttpFunctionEndpointSpec;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClientFactory;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyFunction;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.StatefulFunction;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;

@NotThreadSafe
public final class HttpFunctionProvider
implements StatefulFunctionProvider,
ManagingResources {
    private final HttpFunctionEndpointSpec endpointSpec;
    private final RequestReplyClientFactory requestReplyClientFactory;

    public HttpFunctionProvider(HttpFunctionEndpointSpec endpointSpec, RequestReplyClientFactory requestReplyClientFactory) {
        this.endpointSpec = Objects.requireNonNull(endpointSpec);
        this.requestReplyClientFactory = Objects.requireNonNull(requestReplyClientFactory);
    }

    public StatefulFunction functionOfType(FunctionType functionType) {
        URI endpointUrl = this.endpointSpec.urlPathTemplate().apply(functionType);
        return new RequestReplyFunction(functionType, this.endpointSpec.maxNumBatchRequests(), this.requestReplyClientFactory.createTransportClient(this.endpointSpec.transportClientProperties(), endpointUrl));
    }

    @Override
    public void shutdown() {
        this.requestReplyClientFactory.cleanup();
    }
}

