/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml;

import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;

public class Functions {
    public static ApiExpression vectorToArray(Object ... arguments) {
        return Expressions.call(VectorToArrayFunction.class, (Object[])arguments);
    }

    public static ApiExpression arrayToVector(Object ... arguments) {
        return Expressions.call(ArrayToVectorFunction.class, (Object[])arguments);
    }

    public static class ArrayToVectorFunction
    extends ScalarFunction {
        public DenseVector eval(double[] array) {
            return Vectors.dense(array);
        }

        public DenseVector eval(Double[] array) {
            return this.eval(ArrayUtils.toPrimitive((Double[])array));
        }

        public DenseVector eval(Number[] array) {
            double[] doubles = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                doubles[i] = array[i].doubleValue();
            }
            return this.eval(doubles);
        }

        public TypeInference getTypeInference(DataTypeFactory typeFactory) {
            return TypeInference.newBuilder().outputTypeStrategy(callContext -> Optional.of(DataTypes.of((TypeInformation)DenseVectorTypeInfo.INSTANCE).toDataType(typeFactory))).build();
        }
    }

    public static class VectorToArrayFunction
    extends ScalarFunction {
        public double[] eval(Vector vector) {
            return vector.toArray();
        }

        public TypeInference getTypeInference(DataTypeFactory typeFactory) {
            return TypeInference.newBuilder().outputTypeStrategy(callContext -> Optional.of(DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE))))).build();
        }
    }
}

