/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.proxy.state;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.iteration.proxy.state.StateNamePrefix;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;

public class ProxyOperatorStateBackend
implements OperatorStateBackend {
    private final OperatorStateBackend wrappedBackend;
    private final StateNamePrefix stateNamePrefix;

    public ProxyOperatorStateBackend(OperatorStateBackend wrappedBackend, StateNamePrefix stateNamePrefix) {
        this.wrappedBackend = wrappedBackend;
        this.stateNamePrefix = stateNamePrefix;
    }

    public <K, V> BroadcastState<K, V> getBroadcastState(MapStateDescriptor<K, V> stateDescriptor) throws Exception {
        MapStateDescriptor newDescriptor = new MapStateDescriptor(this.stateNamePrefix.prefix(stateDescriptor.getName()), stateDescriptor.getKeySerializer(), stateDescriptor.getValueSerializer());
        return this.wrappedBackend.getBroadcastState(newDescriptor);
    }

    public <S> ListState<S> getListState(ListStateDescriptor<S> stateDescriptor) throws Exception {
        ListStateDescriptor newDescriptor = new ListStateDescriptor(this.stateNamePrefix.prefix(stateDescriptor.getName()), stateDescriptor.getElementSerializer());
        return this.wrappedBackend.getListState(newDescriptor);
    }

    public <S> ListState<S> getUnionListState(ListStateDescriptor<S> stateDescriptor) throws Exception {
        ListStateDescriptor newDescriptor = new ListStateDescriptor(this.stateNamePrefix.prefix(stateDescriptor.getName()), stateDescriptor.getElementSerializer());
        return this.wrappedBackend.getUnionListState(newDescriptor);
    }

    public Set<String> getRegisteredStateNames() {
        HashSet<String> filteredNames = new HashSet<String>();
        Set names = this.wrappedBackend.getRegisteredStateNames();
        for (String name : names) {
            if (!name.startsWith(this.stateNamePrefix.getNamePrefix())) continue;
            filteredNames.add(name.substring(this.stateNamePrefix.getNamePrefix().length()));
        }
        return filteredNames;
    }

    public Set<String> getRegisteredBroadcastStateNames() {
        HashSet<String> filteredNames = new HashSet<String>();
        Set names = this.wrappedBackend.getRegisteredBroadcastStateNames();
        for (String name : names) {
            if (!name.startsWith(this.stateNamePrefix.getNamePrefix())) continue;
            filteredNames.add(name.substring(this.stateNamePrefix.getNamePrefix().length()));
        }
        return filteredNames;
    }

    public void dispose() {
    }

    public void close() throws IOException {
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<OperatorStateHandle>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) throws Exception {
        return this.wrappedBackend.snapshot(checkpointId, timestamp, streamFactory, checkpointOptions);
    }
}

