/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheReader;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheSnapshot;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheWriter;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.Preconditions;

public class ListStateWithCache<T>
implements ListState<T> {
    private final TypeSerializer<T> serializer;
    private final Path basePath;
    private final DataCacheWriter<T> dataCacheWriter;

    public ListStateWithCache(TypeSerializer<T> serializer, StreamTask<?, ?> containingTask, StreamingRuntimeContext runtimeContext, StateInitializationContext stateInitializationContext, OperatorID operatorID) throws IOException {
        this.serializer = serializer;
        LazyMemorySegmentPool segmentPool = null;
        double fraction = containingTask.getConfiguration().getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.OPERATOR, runtimeContext.getTaskManagerRuntimeInfo().getConfiguration(), runtimeContext.getUserCodeClassLoader());
        if (fraction > 0.0) {
            MemoryManager memoryManager = containingTask.getEnvironment().getMemoryManager();
            segmentPool = new LazyMemorySegmentPool(containingTask, memoryManager, memoryManager.computeNumberOfPages(fraction));
        }
        this.basePath = OperatorUtils.getDataCachePath(containingTask.getEnvironment().getTaskManagerInfo().getConfiguration(), containingTask.getEnvironment().getIOManager().getSpillingDirectoriesPaths());
        List inputs = IteratorUtils.toList(stateInitializationContext.getRawOperatorStateInputs().iterator());
        Preconditions.checkState((inputs.size() < 2 ? 1 : 0) != 0, (Object)"The input from raw operator state should be one or zero.");
        List<Segment> priorFinishedSegments = new ArrayList<Segment>();
        if (inputs.size() > 0) {
            DataCacheSnapshot dataCacheSnapshot = DataCacheSnapshot.recover(((StatePartitionStreamProvider)inputs.get(0)).getStream(), this.basePath.getFileSystem(), OperatorUtils.createDataCacheFileGenerator(this.basePath, "cache", operatorID));
            if (segmentPool != null) {
                dataCacheSnapshot.tryReadSegmentsToMemory(serializer, (MemorySegmentPool)segmentPool);
            }
            priorFinishedSegments = dataCacheSnapshot.getSegments();
        }
        this.dataCacheWriter = new DataCacheWriter<T>(serializer, this.basePath.getFileSystem(), OperatorUtils.createDataCacheFileGenerator(this.basePath, "cache", operatorID), (MemorySegmentPool)segmentPool, priorFinishedSegments);
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        this.dataCacheWriter.writeSegmentsToFiles();
        DataCacheSnapshot dataCacheSnapshot = new DataCacheSnapshot(this.basePath.getFileSystem(), null, this.dataCacheWriter.getSegments());
        context.getRawOperatorStateOutput().startNewPartition();
        dataCacheSnapshot.writeTo((OutputStream)context.getRawOperatorStateOutput());
    }

    public Iterable<T> get() throws Exception {
        List<Segment> segments = this.dataCacheWriter.getSegments();
        return () -> new DataCacheReader<T>(this.serializer, segments);
    }

    public void add(T t) throws Exception {
        this.dataCacheWriter.addRecord(t);
    }

    public void update(List<T> list) throws Exception {
        this.dataCacheWriter.clear();
        this.addAll(list);
    }

    public void addAll(List<T> list) throws Exception {
        for (T t : list) {
            this.add(t);
        }
    }

    public void clear() {
        try {
            this.dataCacheWriter.clear();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

