/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalValues;
import org.apache.flink.table.planner.plan.rules.physical.batch.ImmutableBatchPhysicalConstantTableFunctionScanRule;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.immutables.value.Value;
import scala.Option;

@Value.Enclosing
public class BatchPhysicalConstantTableFunctionScanRule
extends RelRule<BatchPhysicalConstantTableFunctionScanRuleConfig> {
    public static final BatchPhysicalConstantTableFunctionScanRule INSTANCE = BatchPhysicalConstantTableFunctionScanRuleConfig.DEFAULT.toRule();

    protected BatchPhysicalConstantTableFunctionScanRule(BatchPhysicalConstantTableFunctionScanRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        return !RexUtil.containsInputRef(scan.getCall());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelTraitSet traitSet = call.getPlanner().emptyTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
        BatchPhysicalValues values = new BatchPhysicalValues(cluster, traitSet, ImmutableList.of(ImmutableList.of()), cluster.getTypeFactory().createStructType(ImmutableList.of(), ImmutableList.of()));
        FunctionDefinition function = ShortcutUtils.unwrapFunctionDefinition(scan.getCall());
        assert (function != null);
        if (function.getKind() != FunctionKind.TABLE) {
            throw new TableException("Unsupported function for scan:" + function.getKind());
        }
        BatchPhysicalCorrelate replacement = new BatchPhysicalCorrelate(cluster, traitSet, values, scan, (Option<RexNode>)Option.empty(), scan.getRowType(), JoinRelType.INNER);
        call.transformTo(replacement);
    }

    @Value.Immutable
    public static interface BatchPhysicalConstantTableFunctionScanRuleConfig
    extends RelRule.Config {
        public static final BatchPhysicalConstantTableFunctionScanRuleConfig DEFAULT = ImmutableBatchPhysicalConstantTableFunctionScanRule.BatchPhysicalConstantTableFunctionScanRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(FlinkLogicalTableFunctionScan.class).anyInputs()).withDescription("BatchPhysicalConstantTableFunctionScanRule").as(BatchPhysicalConstantTableFunctionScanRuleConfig.class);

        @Override
        default public BatchPhysicalConstantTableFunctionScanRule toRule() {
            return new BatchPhysicalConstantTableFunctionScanRule(this);
        }
    }
}

