/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableRemoteCorrelateSplitRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcCallFinder;
import org.apache.flink.table.planner.plan.rules.logical.ScalarFunctionSplitter;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalCorrelateRule;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.immutables.value.Value;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;

@Value.Enclosing
public class RemoteCorrelateSplitRule
extends RelRule<Config> {
    private final RemoteCalcCallFinder callFinder;

    RemoteCorrelateSplitRule(Config config, RemoteCalcCallFinder callFinder) {
        super(config);
        this.callFinder = callFinder;
    }

    private FlinkLogicalTableFunctionScan createNewScan(FlinkLogicalTableFunctionScan scan, ScalarFunctionSplitter splitter) {
        RexCall rightRexCall = (RexCall)scan.getCall();
        List<RexNode> rightCalcProjects = rightRexCall.getOperands().stream().map(x -> x.accept(splitter)).collect(Collectors.toList());
        RexCall newRightRexCall = rightRexCall.clone(rightRexCall.getType(), rightCalcProjects);
        return new FlinkLogicalTableFunctionScan(scan.getCluster(), scan.getTraitSet(), scan.getInputs(), newRightRexCall, scan.getElementType(), scan.getRowType(), scan.getColumnMappings());
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan tableFunctionScan;
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        RelNode right = ((HepRelVertex)correlate.getRight()).getCurrentRel();
        if (right instanceof FlinkLogicalTableFunctionScan) {
            tableFunctionScan = (FlinkLogicalTableFunctionScan)right;
        } else if (right instanceof FlinkLogicalCalc) {
            tableFunctionScan = StreamPhysicalCorrelateRule.getTableScan((FlinkLogicalCalc)right);
        } else {
            return false;
        }
        RexNode rexNode = tableFunctionScan.getCall();
        if (rexNode instanceof RexCall) {
            return this.callFinder.isRemoteCall(rexNode) && this.callFinder.containsNonRemoteCall(rexNode) || this.callFinder.isNonRemoteCall(rexNode) && this.callFinder.containsRemoteCall(rexNode) || this.callFinder.isRemoteCall(rexNode) && RexUtil.containsFieldAccess(rexNode);
        }
        return false;
    }

    private List<String> createNewFieldNames(RelDataType rowType, final RexBuilder rexBuilder, int primitiveFieldCount, ArrayBuffer<RexNode> extractedRexNodes, List<RexNode> calcProjects) {
        for (int i = 0; i < primitiveFieldCount; ++i) {
            calcProjects.add(RexInputRef.of(i, rowType));
        }
        RexDefaultVisitor<RexNode> visitor = new RexDefaultVisitor<RexNode>(){

            @Override
            public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                RexNode expr = fieldAccess.getReferenceExpr();
                if (expr instanceof RexCorrelVariable) {
                    RelDataTypeField field = fieldAccess.getField();
                    return new RexInputRef(field.getIndex(), field.getType());
                }
                return rexBuilder.makeFieldAccess(expr.accept(this), fieldAccess.getField().getIndex());
            }

            @Override
            public RexNode visitCall(RexCall call) {
                List newProjects = call.getOperands().stream().map(x -> x.accept(this)).collect(Collectors.toList());
                return rexBuilder.makeCall(call.getOperator(), newProjects);
            }

            @Override
            public RexNode visitNode(RexNode rexNode) {
                return rexNode;
            }
        };
        for (RexNode rexNode : extractedRexNodes) {
            if (rexNode instanceof RexCall) {
                RexCall rexCall = (RexCall)rexNode;
                List<RexNode> newProjects = rexCall.getOperands().stream().map(x -> (RexNode)x.accept(visitor)).collect(Collectors.toList());
                RexCall newRexCall = rexCall.clone(rexCall.getType(), newProjects);
                calcProjects.add(newRexCall);
                continue;
            }
            calcProjects.add(rexNode);
        }
        LinkedList<String> nameList = new LinkedList<String>();
        for (int i = 0; i < primitiveFieldCount; ++i) {
            nameList.add(rowType.getFieldNames().get(i));
        }
        Iterator indicesIterator = extractedRexNodes.indices().iterator();
        while (indicesIterator.hasNext()) {
            nameList.add("f" + indicesIterator.next());
        }
        return SqlValidatorUtil.uniquify(nameList, rexBuilder.getTypeFactory().getTypeSystem().isSchemaCaseSensitive());
    }

    private FlinkLogicalCalc createNewLeftCalc(RelNode left, RexBuilder rexBuilder, ArrayBuffer<RexNode> extractedRexNodes, FlinkLogicalCorrelate correlate) {
        LinkedList<RexNode> leftCalcProjects = new LinkedList<RexNode>();
        RelDataType leftRowType = left.getRowType();
        List<String> leftCalcCalcFieldNames = this.createNewFieldNames(leftRowType, rexBuilder, leftRowType.getFieldCount(), extractedRexNodes, leftCalcProjects);
        return new FlinkLogicalCalc(correlate.getCluster(), correlate.getTraitSet(), left, RexProgram.create(leftRowType, leftCalcProjects, null, leftCalcCalcFieldNames, rexBuilder));
    }

    private FlinkLogicalCalc createTopCalc(int primitiveLeftFieldCount, RexBuilder rexBuilder, ArrayBuffer<RexNode> extractedRexNodes, RelDataType calcRowType, FlinkLogicalCorrelate newCorrelate) {
        RexProgram rexProgram = new RexProgramBuilder(newCorrelate.getRowType(), rexBuilder).getProgram();
        int offset = extractedRexNodes.size() + primitiveLeftFieldCount;
        List newTopCalcProjects = rexProgram.getExprList().stream().filter(x -> x instanceof RexInputRef).filter(x -> {
            int index = ((RexInputRef)x).getIndex();
            return index < primitiveLeftFieldCount || index >= offset;
        }).collect(Collectors.toList());
        return new FlinkLogicalCalc(newCorrelate.getCluster(), newCorrelate.getTraitSet(), newCorrelate, RexProgram.create(newCorrelate.getRowType(), newTopCalcProjects, null, calcRowType, rexBuilder));
    }

    private ScalarFunctionSplitter createScalarFunctionSplitter(RexBuilder rexBuilder, int primitiveLeftFieldCount, ArrayBuffer<RexNode> extractedRexNodes, RexNode tableFunctionNode) {
        return new ScalarFunctionSplitter(null, rexBuilder, primitiveLeftFieldCount, extractedRexNodes, node -> {
            if (this.callFinder.isNonRemoteCall(tableFunctionNode)) {
                return this.callFinder.isRemoteCall((RexNode)node);
            }
            if (this.callFinder.containsNonRemoteCall((RexNode)node)) {
                return this.callFinder.isNonRemoteCall((RexNode)node);
            }
            return node instanceof RexFieldAccess;
        }, this.callFinder);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCorrelate newCorrelate;
        AbstractRelNode rightNewInput;
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        RelNode left = ((HepRelVertex)correlate.getLeft()).getCurrentRel();
        RelNode right = ((HepRelVertex)correlate.getRight()).getCurrentRel();
        int primitiveLeftFieldCount = left.getRowType().getFieldCount();
        ArrayBuffer extractedRexNodes = new ArrayBuffer();
        if (right instanceof FlinkLogicalTableFunctionScan) {
            FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)right;
            rightNewInput = this.createNewScan(scan, this.createScalarFunctionSplitter(rexBuilder, primitiveLeftFieldCount, (ArrayBuffer<RexNode>)extractedRexNodes, scan.getCall()));
        } else {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)right;
            FlinkLogicalTableFunctionScan scan = StreamPhysicalCorrelateRule.getTableScan(calc);
            FlinkLogicalCalc mergedCalc = StreamPhysicalCorrelateRule.getMergedCalc(calc);
            FlinkLogicalTableFunctionScan newScan = this.createNewScan(scan, this.createScalarFunctionSplitter(rexBuilder, primitiveLeftFieldCount, (ArrayBuffer<RexNode>)extractedRexNodes, scan.getCall()));
            rightNewInput = mergedCalc.copy(mergedCalc.getTraitSet(), newScan, mergedCalc.getProgram());
        }
        if (!extractedRexNodes.isEmpty()) {
            FlinkLogicalCalc leftCalc = this.createNewLeftCalc(left, rexBuilder, (ArrayBuffer<RexNode>)extractedRexNodes, correlate);
            newCorrelate = new FlinkLogicalCorrelate(correlate.getCluster(), correlate.getTraitSet(), leftCalc, rightNewInput, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        } else {
            newCorrelate = new FlinkLogicalCorrelate(correlate.getCluster(), correlate.getTraitSet(), left, rightNewInput, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        }
        FlinkLogicalCalc newTopCalc = this.createTopCalc(primitiveLeftFieldCount, rexBuilder, (ArrayBuffer<RexNode>)extractedRexNodes, correlate.getRowType(), newCorrelate);
        call.transformTo(newTopCalc);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(RemoteCorrelateSplitRule.class)) {
            return false;
        }
        RemoteCorrelateSplitRule rule = (RemoteCorrelateSplitRule)object;
        return this.callFinder.equals(rule.callFinder);
    }

    @Override
    public int hashCode() {
        return this.callFinder.hashCode();
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public RemoteCalcCallFinder callFinder();

        public static Config createDefault(RemoteCalcCallFinder callFinder) {
            return ImmutableRemoteCorrelateSplitRule.Config.builder().callFinder(callFinder).build().withOperandSupplier(b0 -> b0.operand(FlinkLogicalCorrelate.class).anyInputs());
        }

        @Override
        default public RelOptRule toRule() {
            return new RemoteCorrelateSplitRule(this.withDescription("RemoteCorrelateSplitRule-" + this.callFinder().getName()).as(Config.class), this.callFinder());
        }
    }
}

