/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.StateMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.StreamingMultiJoinOperatorFactory;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.JoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-multi-join", version=1, producedTransformations={"multi-join"}, minPlanVersion=FlinkVersion.v2_1, minStateVersion=FlinkVersion.v2_1)
public class StreamExecMultiJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String MULTI_JOIN_TRANSFORMATION = "multi-join";
    private static final String FIELD_NAME_JOIN_TYPES = "joinTypes";
    private static final String FIELD_NAME_JOIN_CONDITIONS = "joinConditions";
    private static final String FIELD_NAME_JOIN_ATTRIBUTE_MAP = "joinAttributeMap";
    private static final String FIELD_NAME_INPUT_UPSERT_KEYS = "inputUpsertKeys";
    private static final String FIELD_NAME_MULTI_JOIN_CONDITION = "multiJoinCondition";
    @JsonProperty(value="joinTypes")
    private final List<FlinkJoinType> joinTypes;
    @JsonProperty(value="joinConditions")
    private final List<? extends @Nullable RexNode> joinConditions;
    @JsonProperty(value="multiJoinCondition")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final RexNode multiJoinCondition;
    @JsonProperty(value="joinAttributeMap")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap;
    @JsonProperty(value="inputUpsertKeys")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<List<int[]>> inputUpsertKeys;
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<StateMetadata> stateMetadataList;

    public StreamExecMultiJoin(ReadableConfig tableConfig, List<FlinkJoinType> joinTypes, List<? extends @Nullable RexNode> joinConditions, @Nullable RexNode multiJoinCondition, Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap, List<List<int[]>> inputUpsertKeys, Map<Integer, Long> stateTtlFromHint, List<InputProperty> inputProperties, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecMultiJoin.class), ExecNodeContext.newPersistedConfig(StreamExecMultiJoin.class, tableConfig), joinTypes, joinConditions, multiJoinCondition, joinAttributeMap, inputUpsertKeys, StateMetadata.getMultiInputOperatorDefaultMeta(stateTtlFromHint, tableConfig, StreamExecMultiJoin.generateStateNames(inputProperties.size())), inputProperties, outputType, description);
    }

    @JsonCreator
    public StreamExecMultiJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinTypes") List<FlinkJoinType> joinTypes, @JsonProperty(value="joinConditions") List<? extends @Nullable RexNode> joinConditions, @JsonProperty(value="multiJoinCondition") @Nullable RexNode multiJoinCondition, @JsonProperty(value="joinAttributeMap") Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap, @JsonProperty(value="inputUpsertKeys") List<List<int[]>> inputUpsertKeys, @JsonProperty(value="state") @Nullable List<StateMetadata> stateMetadataList, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.validateInputs(inputProperties, joinTypes, joinConditions, inputUpsertKeys);
        this.joinTypes = (List)Preconditions.checkNotNull(joinTypes);
        this.joinConditions = (List)Preconditions.checkNotNull(joinConditions);
        this.multiJoinCondition = multiJoinCondition;
        this.joinAttributeMap = (Map)Preconditions.checkNotNull(joinAttributeMap);
        this.inputUpsertKeys = (List)Preconditions.checkNotNull(inputUpsertKeys);
        this.stateMetadataList = stateMetadataList;
    }

    private void validateInputs(List<InputProperty> inputProperties, List<FlinkJoinType> joinTypes, List<? extends @Nullable RexNode> joinConditions, List<List<int[]>> inputUpsertKeys) {
        Preconditions.checkArgument((inputProperties.size() >= 2 ? 1 : 0) != 0, (Object)"Multi-input join operator needs at least 2 inputs.");
        Preconditions.checkArgument((joinTypes.size() == inputProperties.size() ? 1 : 0) != 0, (Object)"Size of joinTypes must match the number of inputs.");
        Preconditions.checkArgument((joinConditions.size() == inputProperties.size() ? 1 : 0) != 0, (Object)"Size of joinConditions must match the number of inputs.");
        Preconditions.checkArgument((inputUpsertKeys.size() == inputProperties.size() ? 1 : 0) != 0, (Object)"Size of inputUpsertKeys must match the number of inputs.");
    }

    private static String[] generateStateNames(int numInputs) {
        return (String[])IntStream.range(0, numInputs).mapToObj(i -> "input-state-" + i).toArray(String[]::new);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        List<ExecEdge> inputEdges = this.getInputEdges();
        int numInputs = inputEdges.size();
        ClassLoader classLoader = planner.getFlinkContext().getClassLoader();
        ArrayList<Transformation<RowData>> inputTransforms = new ArrayList<Transformation<RowData>>(numInputs);
        ArrayList<InternalTypeInfo<RowData>> inputTypeInfos = new ArrayList<InternalTypeInfo<RowData>>(numInputs);
        ArrayList<RowType> inputRowTypes = new ArrayList<RowType>(numInputs);
        for (ExecEdge inputEdge : inputEdges) {
            Transformation<?> transform = inputEdge.translateToPlan(planner);
            inputTransforms.add(transform);
            RowType inputType = (RowType)inputEdge.getOutputType();
            inputRowTypes.add(inputType);
            inputTypeInfos.add(InternalTypeInfo.of((RowType)inputType));
        }
        AttributeBasedJoinKeyExtractor keyExtractor = new AttributeBasedJoinKeyExtractor(this.joinAttributeMap, inputRowTypes);
        ArrayList<JoinInputSideSpec> inputSideSpecs = new ArrayList<JoinInputSideSpec>();
        for (int i = 0; i < numInputs; ++i) {
            inputSideSpecs.add(JoinUtil.analyzeJoinInput(planner.getFlinkContext().getClassLoader(), (InternalTypeInfo<RowData>)((InternalTypeInfo)inputTypeInfos.get(i)), keyExtractor.getJoinKeyIndices(i), this.inputUpsertKeys.get(i)));
        }
        GeneratedJoinCondition[] generatedJoinConditions = this.createJoinConditions(config, classLoader, inputRowTypes);
        StreamOperatorFactory<RowData> operatorFactory = this.createOperatorFactory(config, inputTypeInfos, inputSideSpecs, generatedJoinConditions, (JoinKeyExtractor)keyExtractor);
        List<KeySelector<RowData, RowData>> commonJoinKeySelectors = this.createKeySelectors(planner, inputTypeInfos, (JoinKeyExtractor)keyExtractor);
        TransformationMetadata metadata = this.createTransformationMeta(MULTI_JOIN_TRANSFORMATION, config);
        Transformation<RowData> transform = this.createTransformation(inputTransforms, metadata, operatorFactory, commonJoinKeySelectors, (JoinKeyExtractor)keyExtractor);
        if (this.inputsContainSingleton()) {
            transform.setParallelism(1);
            transform.setMaxParallelism(1);
        }
        return transform;
    }

    private GeneratedJoinCondition[] createJoinConditions(ExecNodeConfig config, ClassLoader classLoader, List<RowType> inputRowTypes) {
        GeneratedJoinCondition[] generatedJoinConditions = new GeneratedJoinCondition[this.joinConditions.size()];
        for (int i = 0; i < this.joinConditions.size(); ++i) {
            GeneratedJoinCondition generatedCondition;
            RexNode rexCond = this.joinConditions.get(i);
            if (rexCond == null || (generatedCondition = this.generateJoinConditionForInput(config, classLoader, rexCond, inputRowTypes, i)) == null) continue;
            generatedJoinConditions[i] = generatedCondition;
        }
        return generatedJoinConditions;
    }

    private StreamOperatorFactory<RowData> createOperatorFactory(ExecNodeConfig config, List<InternalTypeInfo<RowData>> inputTypeInfos, List<JoinInputSideSpec> inputSideSpecs, GeneratedJoinCondition[] joinConditions, JoinKeyExtractor keyExtractor) {
        List<Long> stateTtls = StateMetadata.getStateTtlForMultiInputOperator(config, inputTypeInfos.size(), this.stateMetadataList);
        long[] stateRetentionTimes = stateTtls.stream().mapToLong(Long::longValue).toArray();
        return new StreamingMultiJoinOperatorFactory(inputTypeInfos, inputSideSpecs, this.joinTypes, null, stateRetentionTimes, joinConditions, keyExtractor, this.joinAttributeMap);
    }

    private List<KeySelector<RowData, RowData>> createKeySelectors(PlannerBase planner, List<InternalTypeInfo<RowData>> inputTypeInfos, JoinKeyExtractor keyExtractor) {
        return IntStream.range(0, inputTypeInfos.size()).mapToObj(i -> KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), keyExtractor.getCommonJoinKeyIndices(i), (InternalTypeInfo<RowData>)((InternalTypeInfo)inputTypeInfos.get(i)))).collect(Collectors.toList());
    }

    private Transformation<RowData> createTransformation(List<Transformation<RowData>> inputTransforms, TransformationMetadata metadata, StreamOperatorFactory<RowData> operatorFactory, List<KeySelector<RowData, RowData>> keySelectors, JoinKeyExtractor keyExtractor) {
        if (inputTransforms.isEmpty()) {
            throw new IllegalStateException("StreamExecMultiJoin requires at least two inputs.");
        }
        return ExecNodeUtil.createKeyedMultiInputTransformation(inputTransforms, keySelectors, InternalTypeInfo.of((RowType)keyExtractor.getCommonJoinKeyType()), metadata, operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransforms.get(0).getParallelism(), false);
    }

    private GeneratedJoinCondition generateJoinConditionForInput(ExecNodeConfig config, ClassLoader classLoader, RexNode joinCondition, List<RowType> inputRowTypes, int inputIndex) {
        if (inputIndex == 0) {
            return null;
        }
        RowType leftType = this.leftTypeForIndex(inputRowTypes, inputIndex);
        RowType rightType = inputRowTypes.get(inputIndex);
        return JoinUtil.generateConditionFunction((ReadableConfig)config, classLoader, joinCondition, (LogicalType)leftType, (LogicalType)rightType);
    }

    private RowType leftTypeForIndex(List<RowType> inputRowTypes, int inputIndex) {
        if (inputIndex <= 0) {
            throw new IllegalArgumentException("Input index must be greater than 0 for accumulated left type calculation");
        }
        LogicalType[] fieldTypes = (LogicalType[])inputRowTypes.stream().limit(inputIndex).flatMap(rowType -> rowType.getChildren().stream()).toArray(LogicalType[]::new);
        return RowType.of((LogicalType[])fieldTypes);
    }
}

